/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strrmtrail.c,v 1.5 2005/06/09 00:43:40 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/str-int.h"

/*
**  SM_STR_RM_TRAIL -- Remove trailing characters from string
**
**	Parameters:
**		str -- sm_str_P object to modify.
**		chars -- characters to remove
**
**	Returns:
**		0: nothing changed
**		>0: removed that many characters
**		<0: usual error code (doesn't happen)
*/

sm_ret_T
sm_str_rm_trail(sm_str_P str, const char *rmchars)
{
	uint i;
	int c, n;

	SM_IS_BUF(str);
	SM_REQUIRE(str->sm_str_base != NULL);

	n = 0;
	i = str->sm_str_len;
	while (i > 0)
	{
		c = (int) (str->sm_str_base[i - 1]);
		if (c == '\0' || strchr(rmchars, c) == NULL)
			break;
		--i;
		++n;
	}
	str->sm_str_len = i;
	return n;
}
