/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strshorten.c,v 1.6 2005/06/09 00:43:40 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_SHORTEN -- Shorten a str.
**
**	Parameters:
**		str -- sm_str_P object to shorten.
**		len -- new len (>= 0) or len to cut off from the back (<0)
**
**	Returns:
**		operation was successful
*/

sm_ret_T
sm_str_shorten(sm_str_P str, int len)
{
	SM_IS_BUF(str);
	SM_REQUIRE(str->sm_str_base != NULL);

	if (len >= 0)
	{
		if ((uint)len > str->sm_str_len)
			return sm_error_perm(SM_EM_STR, EINVAL);
		str->sm_str_len = len;
		return SM_SUCCESS;
	}
	if ((uint)(-len) > str->sm_str_len)
		return sm_error_perm(SM_EM_STR, EINVAL);
	str->sm_str_len += len;		/* len < 0 ! */
	return SM_SUCCESS;
}
