/*
 * Copyright (c) 2002, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: tree-search.c,v 1.7 2004/12/29 23:47:35 ca Exp $")

#include "sm/error.h"
#include "sm/assert.h"
#include "sm/tree.h"

/*
**  SM_TREE_LOOKUP -- lookup a node in a tree
**
**	Parameters:
**		tree -- tree
**		key -- key to look for
**		len -- len of key
**
**	Returns:
**		NULL if not found
**		node with key otherwise
*/

sm_tree_node_P
sm_tree_lookup(sm_tree_P tree, sm_tree_key_T key, uint len)
{
	int c;
	sm_tree_node_P n;

	SM_REQUIRE(tree != NULL);
	n = tree->sm_tree_root;
	while (n != NULL &&
	       (c = tree->sm_tree_compare(n->sm_tree_key, key, len)) != 0)
	{
		if (c > 0)
			n = n->sm_tree_left;
		else
			n = n->sm_tree_right;
	}
	return n;
}
