/*
**  This file is derived from inetd.c
**	"@(#)from: inetd.c	8.4 (Berkeley) 4/13/94";
**  as available in the OpenBSD source tree.
**  It has been significantly modified to suit the needs as sendmail MCP.
*/

/*
 * Copyright (c) 1983, 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: inetdconf.h,v 1.8 2005/06/16 00:39:08 ca Exp $ */

#ifndef INETDCONF_H
#define INETDCONF_H 1

#include "sm/generic.h"

#define SE_IS_ACCEPT(sep)	SE_IS_FLAG(sep, SE_FL_ACCEPT)
#define SE_IS_PASS(sep)	\
	(SE_IS_FLAG(sep, SE_FL_PASS) && (sep)->se_exsock != NULL \
	 && *((sep)->se_exsock) != '\0' && *((sep)->se_exsock) != SM_MCP_DEFAULT_CHAR)
#define SE_PASS_FD(sep, fd)	(SE_IS_PASS(sep) && is_valid_socket(fd))

#if 0
#define DONOTBIND(sep)	((sep)->se_proto == NULL || \
			*((sep)->se_proto) == SM_MCP_DEFAULT_CHAR)
#else /* 0 */
#define DONOTBIND(sep)	(!SE_IS_FLAG(sep, SE_FL_PASS|SE_FL_ACCEPT))
#endif /* 0 */

extern char		*CONFIG;
extern fd_set		Allsock;
extern sigset_t		Blockmask;
extern int		Debug;
extern servtab_P	Servtab;
extern struct in_addr	Bind_address;
extern int		Minchild;
extern int		Maxchild;

/* prototypes */
int		 se_config(mcp_ctx_P _mcp_ctx, bool _first);
void		 se_setup(servtab_P _sep);
void		 close_sep(servtab_P _sep);

servtab_P	 se_findsepbyname(char const *_name);
void		 se_enable(servtab_P _sep, bool _completely);
void		 se_disable(servtab_P _sep, bool _completely);

#endif /* INETDCONF_H */
