/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: dnsbl.h,v 1.6 2005/08/15 16:57:46 ca Exp $
 */

#ifndef DNSBL_H
#define DNSBL_H 1

#include "sm/generic.h"
#include "sm/smar.h"

/* callback function to return result */
typedef sm_ret_T (smar_dnsbl_cb_F)(smar_dnsbl_P, void *);

struct smar_dnsbl_S
{
	/* no magic? */

	smar_addr_P	 adbl_addr;	/* address context */
	smar_dnsblres_P	 adbl_res;	/* result structure */
	smar_cnfdnsbl_P	 adbl_cnfdnsbl;	/* configuration data */

	smar_dnsbl_cb_F	*adbl_cbf; /* callback fct to invoke to return result */
	void		*adbl_cb_ctx;	/* context for callback function */
};

sm_ret_T smar_dnsbl_new(smar_addr_P _addr,
			smar_dnsblres_P _dnsblres,
			smar_cnfdnsbl_P _cnfdnsbl,
			smar_dnsbl_cb_F *_cbf,
			void *_cb_ctx,
			smar_dnsbl_P *_psmar_dnsbl);
#if 0
/* static in dnsbl.c */
sm_ret_T smar_dnsbl_free(smar_dnsbl_P _smar_dnsbl);
#endif
sm_ret_T smar_dnsbl_rslv(smar_ctx_P _smar_ctx, smar_dnsbl_P _smar_dnsbl, ipv4_T ipv4, uint _timeout);

#endif /* DNSBL_H */
