/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: smar_clt.c,v 1.7 2005/05/31 21:12:20 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/memops.h"
#include "sm/io.h"
#include "sm/rcb.h"
#include "smar.h"
#include "sm/reccom.h"

/*
**  SMAR_CLT_NEW -- Allocate a new SMAR - SMTPS context
**
**	Parameters:
**		smar_ctx -- SMAR context
**		psmar_clt_ctx -- SMAR client context (output)
**
**	Returns:
**		usual sm_error code
**
**	Last code review: 2004-03-22 17:12:44
**	Last code change:
*/

sm_ret_T
smar_clt_new(smar_ctx_P smar_ctx, smar_clt_ctx_P *psmar_clt_ctx)
{
	smar_clt_ctx_P smar_clt_ctx;
	sm_ret_T ret;

	SM_IS_SMAR_CTX(smar_ctx);
	SM_REQUIRE(psmar_clt_ctx != NULL);
	smar_clt_ctx = (smar_clt_ctx_P) sm_zalloc(sizeof(*smar_clt_ctx));
	if (smar_clt_ctx == NULL)
		return sm_error_temp(SM_EM_AR, ENOMEM);
	smar_clt_ctx->smac_ar_ctx = smar_ctx;
	ret = sm_rcbcom_open(&(smar_clt_ctx->smac_com_ctx));
	if (sm_is_err(ret))
		goto error;
	smar_clt_ctx->smac_status = SMAC_ST_NONE;
#if 0
	smar_clt_ctx->smac_id = SMAC_ID_NONE;
#endif /* 0 */
	smar_clt_ctx->sm_magic = SM_SMAC_CTX_MAGIC;
	*psmar_clt_ctx = smar_clt_ctx;
	return SM_SUCCESS;

  error:
	SM_FREE(smar_clt_ctx);
	return ret;
}

/*
**  SMAR_CLT_FREE -- Free a SMAR client context
**
**	Parameters:
**		smar_clt_ctx -- SMAR client context
**
**	Returns:
**		usual sm_error code
**
**	Last code review: 2004-03-22 17:24:34
**	Last code change:
*/

sm_ret_T
smar_clt_free(smar_clt_ctx_P smar_clt_ctx)
{
	/* XXX this routine assumes nobody accesses smar_clt_ctx! */
	if (smar_clt_ctx == NULL)
		return SM_SUCCESS;
	(void) sm_rcbcom_close(&(smar_clt_ctx->smac_com_ctx));
	smar_clt_ctx->sm_magic = SM_MAGIC_NULL;
	sm_free_size(smar_clt_ctx, sizeof(*smar_clt_ctx));
	return SM_SUCCESS;
}
