#!/bin/sh
# $Id: t-lalias-0.sh,v 1.8 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias expansion for RFC2821 addresses.
# Uses smar, t-smar-1, "aliases" map, t-mm, startsmar.sh
# and t-hostname
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

ALIAS=lalias-0
OUT=lalias-0.out
RES=lalias-0.ip
OK=lalias-0.ok
TPRG=./t-smar-1
# Note: reference to t-hostname! XREF
HOSTNAME=`../libmta/t-hostname -l -V 2>/dev/null`
killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}
exit 1
}

# create map for smar
rm -f ${ALIMAP}
cat > ${ALIAS} <<EOF
user:	local:
a:	<a1@x.y> <a2@y.z>
b@b.c:	<b1@x.y> <b2@y.z>
l1@local.dom:	<user@b.c> <b@b.c> <a@x.y>
EOF

${MM} < ${ALIAS}
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

rm -f ${SOCK} ${PIDS}
trap killit 1 2 3

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
b.c	lmtp:
x.y	[1.2.3.4]
y.z	[2.3.4.5]
EOF

# start SMAR
# XREF: SMARCNF_FL_ALI_LD
SMAROPT="-A 2" ${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${RES} ${OK}

# Problem: the output isn't ordered (asynchronous operation, and
# hash table to list conversion).

TEST=1
# ----------------------------------------
# does not match an alias
${VALGRIND} ${TPRG} -L -VVV '<b@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
IP[0]=127.0.0.255 [7f0000ff]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=2
# ----------------------------------------
# does not match
${VALGRIND} ${TPRG} -L -VVV '<a@x.y>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
IP[0]=1.2.3.4 [1020304]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=3
# ----------------------------------------
# matches alias
${VALGRIND} ${TPRG} -L -VVV '<b@b.c>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliases=2
alias 0/2
aliased=<b1@x.y>
IP[0]=1.2.3.4 [1020304]
alias 1/2
aliased=<b2@y.z>
IP[0]=2.3.4.5 [2030405]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=4
# ----------------------------------------
# matches alias
${VALGRIND} ${TPRG} -L -VVV '<l1@local.dom>' > ${OUT} 2>&1
egrep '^(IP|alias)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
aliases=4
alias 0/4
aliased=<b1@x.y>
IP[0]=1.2.3.4 [1020304]
alias 1/4
aliased=<b2@y.z>
IP[0]=2.3.4.5 [2030405]
alias 2/4
aliased=<user@b.c>
IP[0]=127.0.0.255 [7f0000ff]
alias 3/4
aliased=<a@x.y>
IP[0]=1.2.3.4 [1020304]
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed"
  test X"${SM_STOPONERROR}" != X && killit
fi

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
rm -f ${MTMAP}

exit ${ERRS}
