/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.actions.SubMenuAction;
import ancestris.core.resources.Images;
import ancestris.gedcom.GedcomDirectory;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.io.Filter;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ActionSaveViewAsGedcom
extends SubMenuAction {
    private Gedcom gedcom;
    private Map<AbstractAncestrisAction, Filter> actionsMap;
    private boolean isMulti;
    private AbstractAncestrisAction mainAction = null;
    private static int GROUP_SIZE = 20;

    public ActionSaveViewAsGedcom(Gedcom gedcom, Filter filter) {
        this.isMulti = false;
        this.init(gedcom);
        this.mainAction = this.createActionFromFilter(filter, true);
    }

    /*
     * WARNING - void declaration
     */
    public ActionSaveViewAsGedcom(Gedcom gedcom, List<? extends Filter> filters) {
        this.isMulti = true;
        this.init(gedcom);
        if (filters.size() <= GROUP_SIZE + 10) {
            for (Filter filter : filters) {
                this.addAction(this.createActionFromFilter(filter, false));
            }
        } else {
            int size = filters.size();
            int n = 0;
            boolean completed = true;
            SubMenuAction actionsLevelLeaf = new SubMenuAction();
            actionsLevelLeaf.setText(n + 1 + "-" + (n + GROUP_SIZE));
            for (Filter filter : filters) {
                void var4_7;
                actionsLevelLeaf.addAction(this.createActionFromFilter(filter, false));
                completed = false;
                if (++var4_7 % GROUP_SIZE != false) continue;
                this.addAction(actionsLevelLeaf);
                actionsLevelLeaf = new SubMenuAction();
                actionsLevelLeaf.setText((int)(var4_7 + true) + "-" + Math.min((int)(var4_7 + GROUP_SIZE), size));
                completed = true;
            }
            if (!completed) {
                this.addAction(actionsLevelLeaf);
            }
        }
    }

    private void init(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.actionsMap = new HashMap<AbstractAncestrisAction, Filter>();
        this.setImage(Images.imgExport);
        this.setTip(NbBundle.getMessage(ActionSaveViewAsGedcom.class, (String)"saveView.tip"));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.isMulti) {
            super.actionPerformed(event);
            return;
        }
        this.mainAction.actionPerformed(event);
    }

    private AbstractAncestrisAction createActionFromFilter(final Filter f, boolean isIcon) {
        AbstractAncestrisAction action = new AbstractAncestrisAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ActionSaveViewAsGedcom.exportFilter(ActionSaveViewAsGedcom.this.gedcom, f);
            }
        };
        if (isIcon) {
            action.setImage(Images.imgDownload);
        } else {
            action.setText(f.getFilterName());
        }
        this.actionsMap.put(action, f);
        return action;
    }

    public void refreshNames() {
        for (AbstractAncestrisAction action : this.actionsMap.keySet()) {
            Filter f = this.actionsMap.get(action);
            action.setText(f.getFilterName());
        }
    }

    public static void exportFilter(Gedcom gedcom, Filter f) {
        String msg;
        String nbOfEntities = String.valueOf(f.getIndividualsCount());
        String title = NbBundle.getMessage(ActionSaveViewAsGedcom.class, (String)"saveview.msgTitle", (Object)nbOfEntities);
        FileObject fo = GedcomDirectory.getDefault().saveViewAsGedcom(new Context(gedcom), f, title);
        if (fo != null && DialogManager.YES_OPTION == DialogManager.createYesNo(title = NbBundle.getMessage(ActionSaveViewAsGedcom.class, (String)"saveView.title"), msg = NbBundle.getMessage(ActionSaveViewAsGedcom.class, (String)"saveview.msgTitleSuccess", (Object)nbOfEntities, (Object)(fo.getName() + "." + fo.getExt()))).show()) {
            GedcomDirectory.getDefault().openGedcom(fo);
        }
    }
}

