/*
 * Decompiled with CFR 0.152.
 */
package genj.option;

import genj.option.MultipleChoiceOption;
import genj.option.OptionUI;
import genj.option.OptionsWidget;
import genj.option.PropertyOption;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import org.openide.windows.WindowManager;

public abstract class MultipleSelectionOption
extends MultipleChoiceOption {
    private static final ImageIcon UNSELECTALL = new ImageIcon(MultipleSelectionOption.class, "images/Unselect.png");
    private static final ImageIcon SELECTALL = new ImageIcon(MultipleSelectionOption.class, "images/Select.png");
    private static final ImageIcon RESET = new ImageIcon(MultipleSelectionOption.class, "images/Reset.png");
    private final PropertyOption option;

    public MultipleSelectionOption(PropertyOption option) {
        super(option);
        this.option = option;
    }

    @Override
    public OptionUI getUI(OptionsWidget widget) {
        return new ListUI();
    }

    public class ListUI
    extends JList
    implements OptionUI {
        private static final String SEPARATOR = ", ";
        private final DefaultListModel model;
        private final String emptyText;
        private final JPanel panel;
        private final JPopupMenu popup;

        private ListUI() {
            this.emptyText = Resources.get(MultipleSelectionOption.this.instance).getString(MultipleSelectionOption.this.property + ".tip", true);
            Object[] choices = MultipleSelectionOption.this.getChoices();
            this.model = new DefaultListModel();
            for (Object o : choices) {
                JCheckBox cb = new JCheckBox(o.toString());
                this.model.addElement(cb);
            }
            this.setModel(this.model);
            this.setCellRenderer(new ListUICellRenderer());
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ListUI.this.listMouseClicked(evt);
                }
            });
            this.setSelectionFromValue(MultipleSelectionOption.this.getValue());
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 3));
            this.popup = new JPopupMenu();
            this.setVisibleRowCount(Math.min(20, this.model.getSize()));
            JScrollPane scrollPane = new JScrollPane(this);
            scrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1, true));
            this.popup.add(scrollPane);
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
            JButton selectAllButton = new JButton(SELECTALL);
            JButton resetButton = new JButton(RESET);
            JButton unselectAllButton = new JButton(UNSELECTALL);
            selectAllButton.addActionListener(e -> this.setAll(true));
            resetButton.addActionListener(e -> this.setSelectionFromValue(MultipleSelectionOption.this.getValue()));
            unselectAllButton.addActionListener(e -> this.setAll(false));
            buttonPanel.add(selectAllButton);
            buttonPanel.add(resetButton);
            buttonPanel.add(unselectAllButton);
            this.popup.add(buttonPanel);
            this.panel.add(this.popup);
        }

        @Override
        public JComponent getComponentRepresentation() {
            WindowManager.getDefault().invokeWhenUIReady(() -> this.popup.show(this.panel, 0, 0));
            return this.panel;
        }

        @Override
        public String getTextRepresentation() {
            return this.getTextFromSelection();
        }

        @Override
        public void endRepresentation() {
            this.popup.setVisible(false);
            MultipleSelectionOption.this.setValue(this.getIndicesFromSelection());
        }

        private void listMouseClicked(MouseEvent evt) {
            int index = this.locationToIndex(evt.getPoint());
            if (index != -1) {
                JCheckBox cb;
                cb.setSelected(!(cb = (JCheckBox)this.model.get(index)).isSelected());
                this.repaint();
            }
        }

        private void setSelectionFromValue(Object value) {
            if (value instanceof int[]) {
                int[] indices = (int[])value;
                this.setAll(false);
                for (int index : indices) {
                    if (index >= this.model.getSize()) continue;
                    JCheckBox cb = (JCheckBox)this.model.getElementAt(index);
                    cb.setSelected(true);
                }
                this.repaint();
            }
        }

        private int[] getIndicesFromSelection() {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            Integer index = 0;
            while (index < this.model.getSize()) {
                JCheckBox cb = (JCheckBox)this.model.getElementAt(index);
                if (cb.isSelected()) {
                    ret.add(index);
                }
                Integer n = index;
                index = index + 1;
            }
            return ret.stream().mapToInt(i -> i).toArray();
        }

        private String getTextFromSelection() {
            String display;
            int[] indices = this.getIndicesFromSelection();
            StringBuilder sb = new StringBuilder("");
            for (int index : indices) {
                if (sb.length() > 60) {
                    sb.append("...");
                    break;
                }
                JCheckBox cb = (JCheckBox)this.model.getElementAt(index);
                sb.append(cb.getText());
                sb.append(SEPARATOR);
            }
            return (display = sb.toString().replaceAll(", $", "")).isBlank() ? this.emptyText : display;
        }

        private void setAll(boolean set) {
            for (int index = 0; index < this.model.getSize(); ++index) {
                JCheckBox cb = (JCheckBox)this.model.getElementAt(index);
                cb.setSelected(set);
            }
            this.repaint();
        }
    }

    private static class ListUICellRenderer
    implements ListCellRenderer<JCheckBox> {
        @Override
        public Component getListCellRendererComponent(JList<? extends JCheckBox> list, JCheckBox value, int index, boolean isSelected, boolean cellHasFocus) {
            return value;
        }
    }
}

