/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.util;

import java.awt.AWTException;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Screenshot {
    private final BufferedImage image;
    private static Robot robot;

    public static final Screenshot capture(Rectangle rectangle) throws AWTException {
        return new Screenshot(Screenshot.getRobot().createScreenCapture(rectangle));
    }

    public static final Screenshot capture(int n, int n2) throws AWTException {
        return Screenshot.capture(new Rectangle(n, n2));
    }

    private static synchronized Robot getRobot() throws AWTException {
        if (robot == null) {
            robot = new Robot();
        }
        return robot;
    }

    private Screenshot(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean store(String string, File file) throws IOException {
        return ImageIO.write((RenderedImage)this.image, string, file);
    }

    public static final List<DisplayMode> getDisplayInfo() {
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        for (GraphicsDevice graphicsDevice : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            arrayList.add(graphicsDevice.getDisplayMode());
        }
        return arrayList;
    }
}

