/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.anchor;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public abstract class Anchor
implements Widget.Dependency {
    public static final EnumSet<Direction> DIRECTION_ANY = EnumSet.allOf(Direction.class);
    private boolean attachedToWidget;
    private Widget relatedWidget;
    private ArrayList<Entry> entries = new ArrayList();

    protected Anchor(Widget relatedWidget) {
        this.relatedWidget = relatedWidget;
    }

    public final void addEntry(Entry entry) {
        if (entry == null) {
            return;
        }
        this.notifyEntryAdded(entry);
        this.entries.add(entry);
        if (!this.attachedToWidget && this.entries.size() > 0) {
            this.attachedToWidget = true;
            if (this.relatedWidget != null) {
                this.relatedWidget.addDependency(this);
            }
            this.notifyUsed();
        }
        this.revalidateDependency();
    }

    public final void removeEntry(Entry entry) {
        this.entries.remove(entry);
        this.notifyEntryRemoved(entry);
        if (this.attachedToWidget && this.entries.size() <= 0) {
            this.attachedToWidget = false;
            if (this.relatedWidget != null) {
                this.relatedWidget.removeDependency(this);
            }
            this.notifyUnused();
        }
        this.revalidateDependency();
    }

    public final void addEntries(List<Entry> entries) {
        for (Entry entry : entries) {
            this.addEntry(entry);
        }
    }

    public final void removeEntries(List<Entry> entries) {
        for (Entry entry : entries) {
            this.removeEntry(entry);
        }
    }

    public final List<Entry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    protected void notifyEntryAdded(Entry entry) {
    }

    protected void notifyEntryRemoved(Entry entry) {
    }

    protected final boolean isUsed() {
        return this.attachedToWidget;
    }

    protected void notifyUsed() {
    }

    protected void notifyUnused() {
    }

    protected void notifyRevalidate() {
    }

    @Override
    public final void revalidateDependency() {
        this.notifyRevalidate();
        for (Entry entry : this.entries) {
            entry.revalidateEntry();
        }
    }

    public Widget getRelatedWidget() {
        return this.relatedWidget;
    }

    public Point getRelatedSceneLocation() {
        if (this.relatedWidget != null) {
            Rectangle bounds = this.relatedWidget.getBounds();
            if (bounds == null) {
                throw new IllegalStateException("Widget (" + this.relatedWidget + ") was not added into the scene");
            }
            return GeomUtil.center(this.relatedWidget.convertLocalToScene(bounds));
        }
        assert (false) : "Anchor.getRelatedSceneLocation has to be overridden when a related widget is not used";
        return null;
    }

    public Point getOppositeSceneLocation(Entry entry) {
        Anchor oppositeAnchor = entry.getOppositeAnchor();
        return oppositeAnchor != null ? oppositeAnchor.getRelatedSceneLocation() : null;
    }

    public boolean allowsArbitraryConnectionPlacement() {
        return false;
    }

    public List<Point> compute(List<Point> bestPoints) {
        return bestPoints;
    }

    public abstract Result compute(Entry var1);

    public static interface Entry {
        public void revalidateEntry();

        public ConnectionWidget getAttachedConnectionWidget();

        public boolean isAttachedToConnectionSource();

        public Anchor getAttachedAnchor();

        public Anchor getOppositeAnchor();
    }

    public static enum Direction {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM;

    }

    public final class Result {
        private Point anchorSceneLocation;
        private EnumSet<Direction> directions;

        public Result(Point anchorSceneLocation, Direction direction) {
            this(anchorSceneLocation, EnumSet.of(direction));
        }

        public Result(Point anchorSceneLocation, EnumSet<Direction> directions) {
            this.anchorSceneLocation = anchorSceneLocation;
            this.directions = directions;
        }

        public Point getAnchorSceneLocation() {
            return this.anchorSceneLocation;
        }

        public EnumSet<Direction> getDirections() {
            return this.directions;
        }
    }
}

