/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyXRef;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.openide.util.NbBundle;

public class FamilyReferencesTreeTableModel
extends AbstractTreeTableModel {
    public static int FAMILY_CHILD = 1;
    public static int FAMILY_SPOUSE = 2;
    private int mFamilyTableType = FAMILY_CHILD;
    private static String[] familyChildColumnsName = new String[]{NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familyChild.column.ID.title"), NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familyChild.column.husband.title"), NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familyChild.column.wife.title"), NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familyChild.column.date.title")};
    private static String[] familySpouseColumnsName = new String[]{NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familySpouse.column.ID.title"), NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familySpouse.column.husband.title"), NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familySpouse.column.wife.title"), NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familySpouse.column.date.title")};
    private String[] familyColumnsName = familyChildColumnsName;
    private String mFemale = "";
    private String mMale = "";
    private Property mRoot = null;

    public FamilyReferencesTreeTableModel() {
        this(FAMILY_CHILD);
    }

    public FamilyReferencesTreeTableModel(int familyType) {
        super((Object)new DefaultMutableTreeNode());
        this.mFamilyTableType = familyType;
        if (this.mFamilyTableType == FAMILY_CHILD) {
            this.familyColumnsName = familyChildColumnsName;
            this.mFemale = NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familyChild.female.title");
            this.mMale = NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familyChild.male.title");
        } else if (this.mFamilyTableType == FAMILY_SPOUSE) {
            this.familyColumnsName = familySpouseColumnsName;
            this.mFemale = NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familySpouse.female.title");
            this.mMale = NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.familySpouse.male.title");
        }
    }

    public int getColumnCount() {
        return this.familyColumnsName.length;
    }

    public String getColumnName(int column) {
        if (column < this.familyColumnsName.length) {
            return this.familyColumnsName[column];
        }
        return "";
    }

    public Object getValueAt(Object object, int index) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode dataNode = (DefaultMutableTreeNode)object;
            Property property = (Property)dataNode.getUserObject();
            if (property instanceof PropertyXRef) {
                Entity entity = ((PropertyXRef)property).getTargetEntity().orElse(null);
                if (entity instanceof Fam) {
                    Fam family = (Fam)entity;
                    switch (index) {
                        case 0: {
                            return family.getId();
                        }
                        case 1: {
                            return family.getHusband() != null ? family.getHusband().getName() : "";
                        }
                        case 2: {
                            return family.getWife() != null ? family.getWife().getName() : "";
                        }
                        case 3: {
                            return family.getMarriageDate() != null ? NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.family.wedding") + " " + family.getMarriageDate().getDisplayValue() : "";
                        }
                    }
                    return "";
                }
                if (entity instanceof Indi) {
                    Indi child = (Indi)entity;
                    switch (index) {
                        case 0: {
                            if (child == this.mRoot) {
                                return child.getId();
                            }
                            switch (child.getSex()) {
                                case 1: {
                                    return this.mMale + " (" + child.getId() + ")";
                                }
                                case 2: {
                                    return this.mFemale + " (" + child.getId() + ")";
                                }
                            }
                            return child.getId();
                        }
                        case 1: {
                            return child.getFirstName();
                        }
                        case 2: {
                            return child.getLastName();
                        }
                        case 3: {
                            return child.getBirthDate() != null ? NbBundle.getMessage(FamilyReferencesTreeTableModel.class, (String)"FamilyReferencesTreeTableModel.child.birth") + " " + child.getBirthDate().getDisplayValue() : "";
                        }
                    }
                    return "";
                }
                return "";
            }
            return "";
        }
        return object.getClass().getCanonicalName();
    }

    public Object getChild(Object object, int index) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode nodes = (DefaultMutableTreeNode)object;
            return nodes.getChildAt(index);
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode nodes = (DefaultMutableTreeNode)object;
            return nodes.getChildCount();
        }
        return 0;
    }

    public int getIndexOfChild(Object o, Object o1) {
        return 0;
    }

    public void setRoot(Property root) {
        this.mRoot = root;
    }

    public void add(PropertyXRef familyRef) {
        DefaultMutableTreeNode familyNode = new DefaultMutableTreeNode(familyRef);
        Entity entity = familyRef.getTargetEntity().orElse(null);
        if (entity instanceof Fam) {
            Fam family = (Fam)entity;
            for (PropertyChild childRef : family.getProperties(PropertyChild.class)) {
                familyNode.add(new DefaultMutableTreeNode(childRef));
            }
        }
        ((DefaultMutableTreeNode)this.getRoot()).add(familyNode);
        this.modelSupport.fireNewRoot();
    }

    public void addAll(List<? extends PropertyXRef> familiesList) {
        for (PropertyXRef propertyXRef : familiesList) {
            DefaultMutableTreeNode familyNode = new DefaultMutableTreeNode(propertyXRef);
            Entity entity = propertyXRef.getTargetEntity().orElse(null);
            if (entity instanceof Fam) {
                Fam family = (Fam)entity;
                for (PropertyChild childRef : family.getProperties(PropertyChild.class)) {
                    familyNode.add(new DefaultMutableTreeNode(childRef));
                }
                ((DefaultMutableTreeNode)this.getRoot()).add(familyNode);
            }
            this.modelSupport.fireNewRoot();
        }
    }

    public void remove(DefaultMutableTreeNode dataNode) {
        TreeNode parent = dataNode.getParent();
        if (parent instanceof DefaultMutableTreeNode) {
            ((DefaultMutableTreeNode)parent).remove(dataNode);
        }
        this.modelSupport.fireNewRoot();
    }

    public void clear() {
        if (this.root instanceof DefaultMutableTreeNode) {
            ((DefaultMutableTreeNode)this.root).removeAllChildren();
        }
        this.modelSupport.fireNewRoot();
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }
}

