/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.notepad;

import genj.gedcom.Gedcom;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class SearchNote {
    static final String REF = "SEARCH_NOTE_";
    static final DateTimeFormatter ISO_FORMAT = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss_SSS");
    private Gedcom gedcom;
    private final String reference;
    private String content;
    private LocalDateTime lastModified;
    private boolean dirty = false;

    public SearchNote() {
        this.lastModified = LocalDateTime.now();
        this.reference = REF + this.lastModified.format(ISO_FORMAT);
        this.dirty = true;
    }

    public SearchNote(String ref) {
        this.reference = ref;
    }

    public Gedcom getGedcom() {
        return this.gedcom;
    }

    public void setGedcom(Gedcom gedcom) {
        this.gedcom = gedcom;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        if (this.content != null && !this.content.equals(content) || this.content == null) {
            this.dirty = true;
            this.lastModified = LocalDateTime.now();
        }
        this.content = content;
    }

    public String getReference() {
        return this.reference;
    }

    public LocalDateTime getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(LocalDateTime lastModified) {
        this.lastModified = lastModified;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public String toString() {
        return this.reference;
    }
}

