/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.imageAligner;

import ancestris.modules.releve.MainPanelInterface;
import ancestris.modules.releve.ReleveTopComponent;
import ancestris.modules.releve.imageAligner.ImagePanel;
import ancestris.modules.releve.imageBrowser.BrowserOptionsPanel;
import ancestris.util.Utilities;
import ancestris.util.swing.FileChooserBuilder;
import genj.io.InputSource;
import genj.renderer.MediaUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class MainPanelCropper
extends JPanel
implements MainPanelInterface,
ImagePanel.CoordinateListener {
    public static String IMAGE_EXTENSION_PATTERN = ".*\\.jpg$|.*\\.jpeg$|.*\\.png$|.*\\.gif$|.*\\.pdf$";
    private static final String INPUT_IMAGE_DIRECTORY_KEY = "AlignerInputImageDirectory";
    private static final String OUTPUT_IMAGE_DIRECTORY_KEY = "AlignerOutputImageDirectory";
    private static final String SPLIT_PANE_KEY = "AlignerSplitPane";
    private File inputImageDirectory = null;
    private File outputImageDirectory = null;
    private final Set<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
    private JButton cropButton;
    private ImagePanel imagePanel;
    private JButton jButtonInputFolder;
    private JButton jButtonLeft;
    private JButton jButtonOutputFolder;
    private JButton jButtonRight;
    private JPanel jPanel4;
    private JPanel jPanelButton;
    private JPanel jPanelFiles;
    private JPanel jPanelImage;
    private JPanel jPanelImageInfo;
    private JScrollPane jScrollPaneFiles;
    private JScrollPane jScrollPaneImage;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSplitPane jSplitPaneBrowser;
    private JTextField jTextFieldAlignCoords;
    private JTextField jTextFieldMouseCoords;
    private JTextField jTextFieldNameFormat;
    private JTextField jTextFieldNameIndex;
    private JTextField jTextFieldNameValue;
    private JLabel lbFileName;
    private JList<String> listFiles;
    private Box.Filler filler1;

    public MainPanelCropper() {
        File outpuFile;
        String outputDirectoryString;
        File f;
        this.initComponents();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanelButton.setVisible(false);
        this.jPanelImageInfo.setVisible(false);
        int size = Integer.valueOf(NbPreferences.forModule(MainPanelCropper.class).get(SPLIT_PANE_KEY, "10"));
        if (size > 10) {
            this.jSplitPaneBrowser.setDividerLocation(size);
        }
        this.imagePanel.setCoordinateListener(this);
        ListSelectionListener lsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (MainPanelCropper.this.listFiles.getSelectedValue() != null) {
                    MainPanelCropper.this.showImage(MainPanelCropper.this.listFiles.getSelectedValue(), false);
                }
                MainPanelCropper.this.updateCropButton();
            }
        };
        this.listFiles.addListSelectionListener(lsl);
        this.jPanelImage.getInputMap(2).put(KeyStroke.getKeyStroke(37, 512), "previousImage");
        this.jPanelImage.getActionMap().put("previousImage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanelCropper.this.jButtonLeftActionPerformed(null);
            }
        });
        this.jPanelImage.getInputMap(2).put(KeyStroke.getKeyStroke(39, 512), "nextImage");
        this.jPanelImage.getActionMap().put("nextImage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainPanelCropper.this.jButtonRightActionPerformed(null);
            }
        });
        String inputDirectoryString = NbPreferences.forModule(MainPanelCropper.class).get(INPUT_IMAGE_DIRECTORY_KEY, "");
        if (!inputDirectoryString.isBlank() && (f = new File(inputDirectoryString)).exists()) {
            this.inputImageDirectory = f;
            this.populateImageList(this.inputImageDirectory);
            this.jButtonInputFolder.setText(f.getParentFile().getName() + File.separator + f.getName());
        }
        if (!(outputDirectoryString = NbPreferences.forModule(MainPanelCropper.class).get(OUTPUT_IMAGE_DIRECTORY_KEY, "")).isBlank() && (outpuFile = new File(outputDirectoryString)).exists()) {
            this.outputImageDirectory = outpuFile;
            this.jButtonOutputFolder.setText(outpuFile.getParentFile().getName() + File.separator + outpuFile.getName());
            try {
                BrowserOptionsPanel.ImageDirectoryModel.updateDirectory(this.outputImageDirectory.getCanonicalPath());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.updateNameValue();
    }

    @Override
    public String getInfoText() {
        return NbBundle.getMessage(ReleveTopComponent.class, (String)"mainPanelCropper.info");
    }

    @Override
    public JComponent[] getMenuComponents() {
        return new JComponent[]{this.jButtonInputFolder, this.jButtonLeft, this.jButtonRight, this.jSeparator1, this.jTextFieldMouseCoords, this.jTextFieldAlignCoords, this.jSeparator2, this.jButtonOutputFolder, this.jTextFieldNameFormat, this.jTextFieldNameIndex, this.jTextFieldNameValue, this.cropButton, this.filler1};
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        super.addPropertyChangeListener(l);
        if (l instanceof ReleveTopComponent) {
            this.listeners.add(l);
        }
    }

    @Override
    public void firePropertyChangeEvent(PropertyChangeEvent evt) {
        for (PropertyChangeListener l : this.listeners) {
            l.propertyChange(evt);
        }
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public void componentClosed() {
    }

    private void populateImageList(File folder) {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                name = name.toLowerCase();
                return name.matches(IMAGE_EXTENSION_PATTERN);
            }
        });
        if (files != null) {
            String[] fileNames = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                fileNames[i] = files[i].getName();
            }
            Arrays.sort(fileNames, String.CASE_INSENSITIVE_ORDER);
            this.listFiles.setListData((String[])fileNames);
            this.jSplitPaneBrowser.setDividerLocation(this.jScrollPaneFiles.getPreferredSize().width + 6);
        } else {
            System.err.println("BrowserPanel.populateImageList folder.listFiles=null for folder=" + folder.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showImage(String fileName, boolean forceRefesh) {
        if (this.lbFileName.getText().equals(fileName) && !forceRefesh) {
            return;
        }
        Utilities.setCursorWaiting((JPanel)this);
        this.imagePanel.showImage(null);
        this.lbFileName.setText("");
        try {
            String fullFileName = this.inputImageDirectory.getCanonicalPath() + File.separator + fileName;
            Optional is = InputSource.get((File)new File(fullFileName));
            BufferedImage image = MediaUtils.getImageFromFile((InputSource)((InputSource)is.get()), this.getClass(), (BufferedImage)MediaUtils.IMG_NO_SOURCE_MEDIA);
            this.imagePanel.showImage(image);
            this.lbFileName.setText(fileName);
        }
        catch (IOException ex) {
            System.err.println("MainPanelCropper.showImage error =" + ex.getMessage());
        }
        finally {
            Utilities.setCursorNormal((JPanel)this);
        }
    }

    private void updateCropButton() {
        String sel = this.listFiles.getSelectedValue();
        this.cropButton.setEnabled(this.outputImageDirectory != null && sel != null);
    }

    private void initComponents() {
        this.jPanelButton = new JPanel();
        this.jButtonInputFolder = new JButton();
        this.jButtonLeft = new JButton();
        this.jButtonRight = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jTextFieldMouseCoords = new JTextField();
        this.jTextFieldAlignCoords = new JTextField();
        this.jSeparator2 = new JToolBar.Separator();
        this.jButtonOutputFolder = new JButton();
        this.jTextFieldNameFormat = new JTextField();
        this.jTextFieldNameIndex = new JTextField();
        this.jTextFieldNameValue = new JTextField();
        this.cropButton = new JButton();
        this.jPanelImage = new JPanel();
        this.jSplitPaneBrowser = new JSplitPane();
        this.jPanelFiles = new JPanel();
        this.jScrollPaneFiles = new JScrollPane();
        this.listFiles = new JList();
        this.jPanel4 = new JPanel();
        this.jScrollPaneImage = new JScrollPane();
        this.imagePanel = new ImagePanel();
        this.jPanelImageInfo = new JPanel();
        this.lbFileName = new JLabel();
        this.setLayout(new BorderLayout());
        this.jPanelButton.setPreferredSize(new Dimension(0, 40));
        this.jPanelButton.setLayout(new FlowLayout(0));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonInputFolder, (String)NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jButtonInputFolder.text"));
        this.jButtonInputFolder.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jButtonInputFolder.toolTipText"));
        this.jButtonInputFolder.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonInputFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelCropper.this.jButtonInputFolderActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonInputFolder);
        this.jButtonLeft.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Back.png")));
        this.jButtonLeft.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jButtonLeft.toolTipText"));
        this.jButtonLeft.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonLeft.setPreferredSize(new Dimension(52, 29));
        this.jButtonLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelCropper.this.jButtonLeftActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonLeft);
        this.jButtonRight.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Forward.png")));
        this.jButtonRight.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jButtonRight.toolTipText"));
        this.jButtonRight.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonRight.setPreferredSize(new Dimension(52, 29));
        this.jButtonRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelCropper.this.jButtonRightActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonRight);
        this.jPanelButton.add(this.jSeparator1);
        this.jTextFieldMouseCoords.setEditable(false);
        this.jTextFieldMouseCoords.setHorizontalAlignment(0);
        this.jTextFieldMouseCoords.setText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldMouseCoords.text"));
        this.jTextFieldMouseCoords.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldMouseCoords.toolTipText"));
        this.jTextFieldMouseCoords.setPreferredSize(new Dimension(90, 29));
        this.jPanelButton.add(this.jTextFieldMouseCoords);
        this.jTextFieldAlignCoords.setEditable(false);
        this.jTextFieldAlignCoords.setHorizontalAlignment(0);
        this.jTextFieldAlignCoords.setText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldAlignCoords.text"));
        this.jTextFieldAlignCoords.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldAlignCoords.toolTipText"));
        this.jTextFieldAlignCoords.setPreferredSize(new Dimension(90, 29));
        this.jPanelButton.add(this.jTextFieldAlignCoords);
        this.jPanelButton.add(this.jSeparator2);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonOutputFolder, (String)NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jButtonOutputFolder.text"));
        this.jButtonOutputFolder.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jButtonOutputFolder.toolTipText"));
        this.jButtonOutputFolder.setMargin(new Insets(2, 4, 2, 4));
        this.jButtonOutputFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelCropper.this.jButtonOutputFolderActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonOutputFolder);
        this.jTextFieldNameFormat.setHorizontalAlignment(0);
        this.jTextFieldNameFormat.setText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldNameFormat.text"));
        this.jTextFieldNameFormat.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldNameFormat.toolTipText"));
        this.jTextFieldNameFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelCropper.this.jTextFieldNameFormatActionPerformed(evt);
            }
        });
        this.jTextFieldNameFormat.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MainPanelCropper.this.jTextFieldNameFormatKeyReleased(evt);
            }
        });
        this.jPanelButton.add(this.jTextFieldNameFormat);
        this.jTextFieldNameIndex.setColumns(2);
        this.jTextFieldNameIndex.setHorizontalAlignment(0);
        this.jTextFieldNameIndex.setText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldNameIndex.text"));
        this.jTextFieldNameIndex.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldNameIndex.toolTipText"));
        this.jTextFieldNameIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelCropper.this.jTextFieldNameIndexActionPerformed(evt);
            }
        });
        this.jTextFieldNameIndex.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                MainPanelCropper.this.jTextFieldNameIndexKeyReleased(evt);
            }
        });
        this.jPanelButton.add(this.jTextFieldNameIndex);
        this.jTextFieldNameValue.setEditable(false);
        this.jTextFieldNameValue.setBackground(SystemColor.window);
        this.jTextFieldNameValue.setHorizontalAlignment(0);
        this.jTextFieldNameValue.setText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldNameValue.text"));
        this.jTextFieldNameValue.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.jTextFieldNameValue.toolTipText"));
        this.jTextFieldNameValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelCropper.this.jTextFieldNameValueActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jTextFieldNameValue);
        this.cropButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Crop.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.cropButton, (String)NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.cropButton.text"));
        this.cropButton.setToolTipText(NbBundle.getMessage(MainPanelCropper.class, (String)"MainPanelCropper.cropButton.toolTipText"));
        this.cropButton.setEnabled(false);
        this.cropButton.setMargin(new Insets(2, 4, 2, 4));
        this.cropButton.setPreferredSize(new Dimension(52, 29));
        this.cropButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MainPanelCropper.this.cropButtonActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.cropButton);
        this.add((Component)this.jPanelButton, "North");
        this.jPanelImage.setLayout(new BorderLayout());
        this.jPanelFiles.setMinimumSize(new Dimension(150, 23));
        this.jPanelFiles.setPreferredSize(new Dimension(150, 497));
        this.jPanelFiles.setLayout(new BorderLayout());
        this.listFiles.setSelectionMode(0);
        this.listFiles.setMaximumSize(new Dimension(500, 16));
        this.listFiles.setMinimumSize(new Dimension(150, 16));
        this.listFiles.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MainPanelCropper.this.listFilesKeyPressed(evt);
            }
        });
        this.jScrollPaneFiles.setViewportView(this.listFiles);
        this.jPanelFiles.add((Component)this.jScrollPaneFiles, "Center");
        this.jSplitPaneBrowser.setLeftComponent(this.jPanelFiles);
        this.jPanel4.setLayout(new BorderLayout());
        this.imagePanel.setMinimumSize(new Dimension(100, 100));
        GroupLayout imagePanelLayout = new GroupLayout(this.imagePanel);
        this.imagePanel.setLayout(imagePanelLayout);
        imagePanelLayout.setHorizontalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 736, Short.MAX_VALUE));
        imagePanelLayout.setVerticalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 475, Short.MAX_VALUE));
        this.jScrollPaneImage.setViewportView(this.imagePanel);
        this.jPanel4.add((Component)this.jScrollPaneImage, "Center");
        this.jPanelImageInfo.setPreferredSize(new Dimension(585, 20));
        GroupLayout jPanelImageInfoLayout = new GroupLayout(this.jPanelImageInfo);
        this.jPanelImageInfo.setLayout(jPanelImageInfoLayout);
        jPanelImageInfoLayout.setHorizontalGroup(jPanelImageInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelImageInfoLayout.createSequentialGroup().addComponent(this.lbFileName, -1, 751, Short.MAX_VALUE).addContainerGap()));
        jPanelImageInfoLayout.setVerticalGroup(jPanelImageInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbFileName, -1, 20, Short.MAX_VALUE));
        this.jPanel4.add((Component)this.jPanelImageInfo, "North");
        this.jSplitPaneBrowser.setRightComponent(this.jPanel4);
        this.jPanelImage.add((Component)this.jSplitPaneBrowser, "Center");
        this.add((Component)this.jPanelImage, "Center");
    }

    private void jButtonInputFolderActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(MainPanelCropper.class).setDirectoriesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.btnFolder.text")).setApproveText(NbBundle.getMessage(this.getClass(), (String)"BrowserOptionsPanel.dialogTitle.ok")).setSelectedFile(this.inputImageDirectory).setFileHiding(true).showOpenDialog();
        if (file != null) {
            String folderName;
            try {
                this.inputImageDirectory = file;
                folderName = this.inputImageDirectory.getCanonicalPath();
            }
            catch (IOException ex) {
                return;
            }
            this.jButtonInputFolder.setText(file.getParentFile().getName() + File.separator + file.getName());
            this.populateImageList(this.inputImageDirectory);
            NbPreferences.forModule(MainPanelCropper.class).put(INPUT_IMAGE_DIRECTORY_KEY, folderName);
        } else {
            this.populateImageList(this.inputImageDirectory);
        }
    }

    private void jButtonLeftActionPerformed(ActionEvent evt) {
        if (this.imagePanel.isleftSideVisible()) {
            int currentIndex = this.listFiles.getSelectedIndex();
            if (currentIndex > 0) {
                this.listFiles.setSelectedIndex(currentIndex - 1);
            } else {
                this.listFiles.setSelectedIndex(this.listFiles.getModel().getSize() - 1);
                Toolkit.getDefaultToolkit().beep();
            }
            if (this.listFiles == null || this.listFiles.getSelectedValue() == null) {
                return;
            }
            String fileName = this.listFiles.getSelectedValue();
            this.showImage(fileName, false);
            this.jScrollPaneImage.getVerticalScrollBar().setValue(0);
            this.imagePanel.moveToRight();
            this.imagePanel.moveToBottom();
        } else {
            this.imagePanel.moveToLeft();
        }
    }

    private void jButtonRightActionPerformed(ActionEvent evt) {
        if (this.imagePanel.isRightSideVisible()) {
            int currentIndex = this.listFiles.getSelectedIndex();
            if (currentIndex < this.listFiles.getModel().getSize() - 1) {
                this.listFiles.setSelectedIndex(currentIndex + 1);
            } else {
                this.listFiles.setSelectedIndex(0);
                Toolkit.getDefaultToolkit().beep();
            }
            if (this.listFiles == null || this.listFiles.getSelectedValue() == null) {
                return;
            }
            String fileName = this.listFiles.getSelectedValue();
            this.showImage(fileName, false);
            this.jScrollPaneImage.getVerticalScrollBar().setValue(0);
            this.imagePanel.moveToLeft();
            this.imagePanel.moveToTop();
        } else {
            this.imagePanel.moveToRight();
        }
    }

    private void listFilesKeyPressed(KeyEvent evt) {
    }

    private void jButtonOutputFolderActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(MainPanelCropper.class).setDirectoriesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)"MainPanelCropper.jButtonOutputFolder.text")).setApproveText(NbBundle.getMessage(this.getClass(), (String)"BrowserOptionsPanel.dialogTitle.ok")).setSelectedFile(this.outputImageDirectory).setFileHiding(true).showOpenDialog();
        if (file != null) {
            String folderName;
            try {
                this.outputImageDirectory = file;
                folderName = this.outputImageDirectory.getCanonicalPath();
            }
            catch (IOException ex) {
                return;
            }
            this.jButtonOutputFolder.setText(file.getParentFile().getName() + File.separator + file.getName());
            NbPreferences.forModule(MainPanelCropper.class).put(OUTPUT_IMAGE_DIRECTORY_KEY, folderName);
            BrowserOptionsPanel.ImageDirectoryModel.updateDirectory(folderName);
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, ReleveTopComponent.OUTPUT_DIR_CHANGED, this.outputImageDirectory, null));
        }
        this.updateCropButton();
    }

    private void jTextFieldNameFormatActionPerformed(ActionEvent evt) {
        this.updateNameValue();
    }

    private void jTextFieldNameIndexActionPerformed(ActionEvent evt) {
        this.updateNameValue();
    }

    private void jTextFieldNameFormatKeyReleased(KeyEvent evt) {
        this.updateNameValue();
    }

    private void jTextFieldNameIndexKeyReleased(KeyEvent evt) {
        this.updateNameValue();
    }

    private void jTextFieldNameValueActionPerformed(ActionEvent evt) {
    }

    private void cropButtonActionPerformed(ActionEvent evt) {
        this.imagePanel.cropImage();
    }

    private void updateNameValue() {
        if (this.jTextFieldNameIndex.getText().isEmpty()) {
            this.jTextFieldNameValue.setText(String.format("%s-", this.jTextFieldNameFormat.getText()));
        } else {
            try {
                this.jTextFieldNameValue.setText(String.format("%s-%03d", this.jTextFieldNameFormat.getText(), Integer.parseInt(this.jTextFieldNameIndex.getText())));
            }
            catch (Exception e) {
                this.jTextFieldNameValue.setText(String.format("%s-", this.jTextFieldNameFormat.getText()));
            }
        }
    }

    @Override
    public void updateMouseCoordinates(ImagePanel.CoordImage coords) {
        this.jTextFieldMouseCoords.setText(String.format("%d / %d", coords.x, coords.y));
    }

    @Override
    public void updateAlignCoordinates(ImagePanel.CoordImage coords) {
        if (coords != null) {
            this.jTextFieldAlignCoords.setText(String.format("%d / %d", coords.x, coords.y));
        } else {
            this.jTextFieldAlignCoords.setText(" / ");
        }
    }

    @Override
    public void saveCurrentImage(BufferedImage currentImage) {
        try {
            Object fileName = this.listFiles.getSelectedValue();
            fileName = this.jTextFieldNameValue.getText() + ".jpg";
            String fullFileName = this.outputImageDirectory.getCanonicalPath() + File.separator + (String)fileName;
            File file = new File(fullFileName);
            ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
            jpgWriteParam.setCompressionMode(2);
            jpgWriteParam.setCompressionQuality(0.8f);
            ImageOutputStream outputStream = ImageIO.createImageOutputStream(file);
            jpgWriter.setOutput(outputStream);
            currentImage = MainPanelCropper.removeAlphaChannel(currentImage);
            IIOImage outputImage = new IIOImage(currentImage, null, null);
            jpgWriter.write(null, outputImage, jpgWriteParam);
            outputStream.flush();
            outputStream.close();
            jpgWriter.dispose();
            int newIndex = Integer.parseInt(this.jTextFieldNameIndex.getText()) + 1;
            this.jTextFieldNameIndex.setText(String.valueOf(newIndex));
            this.updateNameValue();
            int currentIndex = this.listFiles.getSelectedIndex();
            if (currentIndex < this.listFiles.getModel().getSize() - 1) {
                this.listFiles.setSelectedIndex(currentIndex + 1);
            } else {
                this.listFiles.setSelectedIndex(0);
                Toolkit.getDefaultToolkit().beep();
            }
            fileName = this.listFiles.getSelectedValue();
            this.showImage((String)fileName, false);
            this.jScrollPaneImage.getVerticalScrollBar().setValue(0);
            this.firePropertyChangeEvent(new PropertyChangeEvent(this, ReleveTopComponent.IMAGE_CROPPED, null, null));
        }
        catch (IOException ex) {
            System.err.println("MainPanelCropper.showImage error =" + ex.getMessage());
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void recordSelectionChanged() {
    }

    private static BufferedImage removeAlphaChannel(BufferedImage img) {
        if (!img.getColorModel().hasAlpha()) {
            return img;
        }
        BufferedImage target = MainPanelCropper.createImage(img.getWidth(), img.getHeight(), false);
        Graphics2D g = target.createGraphics();
        g.fillRect(0, 0, img.getWidth(), img.getHeight());
        g.drawImage((Image)img, 0, 0, null);
        g.dispose();
        return target;
    }

    private static BufferedImage createImage(int width, int height, boolean hasAlpha) {
        return new BufferedImage(width, height, hasAlpha ? 2 : 1);
    }

    @Override
    public String getSelectedFileAbsolutePath() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

