/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.exports.geneanet;

import ancestris.core.actions.AbstractAncestrisContextAction;
import ancestris.core.pluginservice.AncestrisPlugin;
import ancestris.gedcom.SaveOptionsWidget;
import ancestris.modules.exports.geneanet.FilterApproxMarcOption;
import ancestris.modules.exports.geneanet.FilterAssociationOption;
import ancestris.modules.exports.geneanet.FilterNSFX;
import ancestris.modules.exports.geneanet.FilterPlaceOption;
import ancestris.modules.exports.geneanet.GeneanetExport;
import ancestris.modules.exports.geneanet.GeneanetSynchronizePanel;
import ancestris.usage.UsageManager;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.io.FileAssociation;
import genj.io.Filter;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class GeneanetExportAction
extends AbstractAncestrisContextAction {
    private static final Logger LOG = Logger.getLogger("ancestris.app", null);

    public GeneanetExportAction() {
        this.setIconBase("ancestris/modules/exports/geneanet/geneanet.png");
        this.setText(NbBundle.getMessage(GeneanetExportAction.class, (String)"CTL_GeneanetExportAction"));
    }

    protected void contextChanged() {
        this.setEnabled(!this.contextProperties.isEmpty());
        super.contextChanged();
    }

    protected void actionPerformedImpl(ActionEvent event) {
        Context contextToOpen = this.getContext();
        if (contextToOpen != null) {
            Gedcom myGedcom = contextToOpen.getGedcom();
            String gedcomName = this.removeExtension(myGedcom.getName());
            ArrayList<Object> theFilters = new ArrayList<Object>(6);
            AncestrisPlugin.lookupAll(Filter.class).stream().filter(f -> f.canApplyTo(myGedcom)).forEachOrdered(f -> theFilters.add(f));
            Lookup.getDefault().lookupAll(Filter.class).stream().filter(f -> f.canApplyTo(myGedcom)).forEachOrdered(f -> theFilters.add(f));
            theFilters.add(new FilterPlaceOption());
            theFilters.add(new FilterAssociationOption());
            theFilters.add(new FilterNSFX());
            theFilters.add(new FilterApproxMarcOption());
            SaveOptionsWidget options = new SaveOptionsWidget(myGedcom, theFilters.toArray(new Filter[0]), SaveOptionsWidget.OptionsSaveType.GENEANET);
            File file = new FileChooserBuilder(GeneanetExportAction.class).setFilesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FileChooserTitle", (Object)myGedcom.getName())).setApproveText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"FileChooserOKButton")).setFileFilter((FileFilter)FileChooserBuilder.getGedcomFilter()).setAcceptAllFileFilterUsed(false).setDefaultExtension(FileChooserBuilder.getGedcomFilter().getExtensions()[0]).setAccessory((JComponent)options).setFileHiding(true).setSelectedFile(new File(gedcomName + "-geneanet")).showSaveDialog();
            if (file != null) {
                options.saveOptions();
                GeneanetExport exportGeneanet = new GeneanetExport(myGedcom, file, options);
                GeneanetExportAction.showWaitCursor();
                boolean b = exportGeneanet.execute();
                String result = b ? NbBundle.getMessage(GeneanetExport.class, (String)"GeneanetExportAction.Sync") : NbBundle.getMessage(GeneanetExport.class, (String)"GeneanetExportAction.Error");
                GeneanetExportAction.hideWaitCursor();
                if (b) {
                    DialogManager dm = DialogManager.createYesNo((String)NbBundle.getMessage(GeneanetExport.class, (String)"GeneanetExportAction.SyncTitle"), (String)result);
                    if (UsageManager.isConnectable() && DialogManager.YES_OPTION.equals(dm.show())) {
                        DialogManager sm = DialogManager.create((String)NbBundle.getMessage(GeneanetExportAction.class, (String)"GeneanetExportAction.SyncTitle"), (JComponent)new GeneanetSynchronizePanel(file, contextToOpen)).setOptionType(10);
                        sm.show();
                    } else {
                        try {
                            FileAssociation.getDefault().execute(new URL("https://my.geneanet.org/arbre/"));
                        }
                        catch (MalformedURLException ex) {
                            LOG.log(Level.FINE, "Unable to contact Geneanet", ex);
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                } else {
                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)result, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            }
        }
    }

    private String removeExtension(String filename) {
        int extensionIndex;
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = filename.lastIndexOf(separator);
        if (lastSeparatorIndex != -1) {
            filename = filename.substring(lastSeparatorIndex + 1);
        }
        if ((extensionIndex = filename.lastIndexOf(".")) == -1) {
            return filename;
        }
        return filename.substring(0, extensionIndex);
    }

    private static void showWaitCursor() {
        Mutex.EVENT.readAccess(() -> {
            JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
            mainWindow.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            mainWindow.getGlassPane().setVisible(true);
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GeneanetExportAction.class, (String)"GeneanetExportAction.Start"));
        });
    }

    private static void hideWaitCursor() {
        Mutex.EVENT.readAccess(() -> {
            StatusDisplayer.getDefault().setStatusText("");
            JFrame mainWindow = (JFrame)WindowManager.getDefault().getMainWindow();
            mainWindow.getGlassPane().setVisible(false);
            mainWindow.getGlassPane().setCursor(null);
        });
    }
}

