/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.List;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.render.gradient.GradientMaker;
import org.apache.fop.render.gradient.Shading;

public class PDFShading
extends PDFObject {
    protected String shadingName;
    private final Shading shading;
    private final PDFFunction pdfFunction;

    public PDFShading(int shadingType, PDFDeviceColorSpace colorSpace, List coords, PDFFunction pdfFunction) {
        this.shading = new Shading(shadingType, colorSpace, coords, pdfFunction.getFunction());
        this.pdfFunction = pdfFunction;
    }

    public String getName() {
        return this.shadingName;
    }

    public void setName(String name) {
        if (name.indexOf(" ") >= 0) {
            throw new IllegalArgumentException("Shading name must not contain any spaces");
        }
        this.shadingName = name;
    }

    @Override
    public String toPDFString() {
        Shading.FunctionRenderer functionRenderer = new Shading.FunctionRenderer(){

            @Override
            public void outputFunction(StringBuilder out) {
                out.append(PDFShading.this.pdfFunction.referencePDF());
            }
        };
        StringBuilder out = new StringBuilder();
        GradientMaker.DoubleFormatter doubleFormatter = new GradientMaker.DoubleFormatter(){

            @Override
            public String formatDouble(double d) {
                return PDFNumber.doubleOut(d);
            }
        };
        this.shading.output(out, doubleFormatter, functionRenderer);
        return out.toString();
    }

    @Override
    protected boolean contentEquals(PDFObject obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PDFShading)) {
            return false;
        }
        Shading other = ((PDFShading)obj).shading;
        if (this.shading.getShadingType() != other.getShadingType()) {
            return false;
        }
        if (this.shading.isAntiAlias() != other.isAntiAlias()) {
            return false;
        }
        if (this.shading.getBitsPerCoordinate() != other.getBitsPerCoordinate()) {
            return false;
        }
        if (this.shading.getBitsPerFlag() != other.getBitsPerFlag()) {
            return false;
        }
        if (this.shading.getBitsPerComponent() != other.getBitsPerComponent()) {
            return false;
        }
        if (this.shading.getVerticesPerRow() != other.getVerticesPerRow()) {
            return false;
        }
        if (this.shading.getColorSpace() != null ? !this.shading.getColorSpace().equals(other.getColorSpace()) : other.getColorSpace() != null) {
            return false;
        }
        if (this.shading.getCoords() != null ? !this.shading.getCoords().equals(other.getCoords()) : other.getCoords() != null) {
            return false;
        }
        if (this.shading.getExtend() != null ? !this.shading.getExtend().equals(other.getExtend()) : other.getExtend() != null) {
            return false;
        }
        return !(this.shading.getFunction() != null ? !this.shading.getFunction().equals(other.getFunction()) : other.getFunction() != null);
    }
}

