/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <errno.h>
#include <stdlib.h>

#include	"LogP.h"
#include	"ScrollWin.h"
#include	"Init.h"
#include	"misc.h"
#include	"utils.h"

#define offset(field) XtOffsetOf(LogRec , log.field)

static XtResource resources[] = { 
	{
	 XtNfont,
	 XtCFont,
	 XtRFontStruct ,
	 sizeof(XFontStruct *) ,
	 offset(font) ,
	 XtRString ,
	 (XtPointer) XtDefaultFont 
	},
        {
         XtNspacing ,
         XtCSpacing ,
         XtRInt ,
         sizeof(int) ,
         offset(spacing) ,
         XtRImmediate ,
         (XtPointer) 5
        },
        {
         XtNselected_fg ,
         XtCSelected_fg ,
         XtRPixel ,
         sizeof(Pixel) ,
         offset(selected_fg) ,
         XtRString ,
         (XtPointer) XtDefaultBackground
        },
        {
         XtNselected_bg ,
         XtCSelected_bg ,
         XtRPixel ,
         sizeof(Pixel) ,
         offset(selected_bg) ,
         XtRString ,
         (XtPointer) XtDefaultForeground
        },
        {
         XtNmaxlines ,
         XtCMaxlines ,
         XtRInt ,
         sizeof(int) ,
         offset(maxlines) ,
         XtRImmediate ,
         (XtPointer) 0
        },
        {
         XtNbottom_grav ,
         XtCBottom_grav ,
         XtRBoolean ,
         sizeof(Boolean) ,
         offset(bottom_grav) ,
         XtRImmediate ,
         (XtPointer) False ,
        },
};

static void ClassInitialize();
static void Initialize ();
static Boolean SetValues ();
static void Redisplay ();
static void Destroy ();
static XtGeometryResult QueryGeometry();

static void Selecting ();
static void Select();

static void Wscrl();
static void SetSW();

static XtActionsRec action [] = {
	{"start_selecting" , Select},
	{"selecting" , Selecting},
	};

static char trans_tab [] =
	"<Btn1Down>: start_selecting() focusCurrent() \n\
	 <Btn1Motion>: selecting() \n\
	 ~Shift<Key>Tab: traverseForward()\n\
	 Shift<Key>Tab: traverseBackward()\n\
	 <FocusIn>: focusIn()\n\
	 <FocusOut>: focusOut()\n\
	 <BtnDown>: focusCurrent()\n\
	 ";

LogClassRec logClassRec = {
/* core */
   {
    /* superclass            */ (WidgetClass) &baseClassRec,
    /* class_name            */ "Log",
    /* widget_size           */ sizeof(LogRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ action,
    /* num_actions           */ XtNumber(action),
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ True,
    /* compress_exposure     */ True,
    /* compress_enterleave   */ True,
    /* visible_interest      */ FALSE,
    /* destroy               */ Destroy,
    /* resize                */ XtInheritResize,
    /* expose                */ Redisplay,
    /* set_values            */ SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ trans_tab,
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
/* base */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* highlight	       */ XtInheritHighlight,
    /* unhighlight	       */ XtInheritUnhighlight,
    /* highlightBorder	       */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },	
/* log */
   {
    /* empty		       */ 0
   },
};
	
WidgetClass logWidgetClass = (WidgetClass) &logClassRec;

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Initialize(req_widget,new_widget,args,num_args)
Widget req_widget;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	LogWidget cw = (LogWidget) new_widget;
        Display *dpy=XtDisplay(new_widget);
        XGCValues gc_res;
        XtGCMask  gc_mask;

        gc_res.foreground = cw->base.foreground;
        gc_res.font = cw->log.font->fid;
	gc_res.background = cw->core.background_pixel;
	
        gc_mask = GCForeground | GCFont | GCBackground;

        cw->log.gc = XCreateGC(dpy,DefaultRootWindow(dpy),
                        gc_mask, &gc_res);

	cw->log.first = NULL;
	cw->log.last = NULL;
	cw->log.numlines = 0;
	cw->log.topx = 0;
	cw->log.topy = 0;

	cw->log.scrolled = (XtClass(XtParent(new_widget))) == 
				scrollWinWidgetClass;

	if (cw->log.scrolled)
	{
		XtVaSetValues(XtParent(new_widget) , XtNslave_mode , True , NULL);

		XtAddCallback(XtParent(new_widget) , XtNscroll_cb , Wscrl , new_widget);
	}

	SetSW(new_widget);
}

static void Destroy(w)
Widget w;
{
	LogWidget cw = (LogWidget) w;
	StrList *p,*q;

	for (p = cw->log.first ; p ; p = q)
	{
		XtFree(p->entry);
		q = p->next;
		XtFree((char *)p);
	}

	XFreeGC(XtDisplay(w) , cw->log.gc);
}

static void Redisplay(w,event,region)
Widget w;
XEvent * event;
Region  region;
{

	LogWidget cw = (LogWidget) w;
        Window root , parent , *childs ;
	Display *dpy = XtDisplay(w);
	Drawable pmap;
	unsigned int pw,ph,bw,dpt,ww,wh;
	int wx,wy,px,py;
	int maxy , miny , y;
	unsigned int nchilds;
	StrList *p;

	if (!XtIsRealized(w)) return;

	XQueryTree(dpy , XtWindow(w) , &root , &parent , &childs , &nchilds);
	if (childs) XFree(childs);
	XGetGeometry(dpy , parent , &root , &px , &py , &pw , &ph , &bw , &dpt); 
	XGetGeometry(dpy , XtWindow(w) , &root , &wx , &wy , &ww , &wh , &bw , &dpt); 
	miny = (wy < 0) ? -wy : 0;
	maxy = (wy + wh > ph) ? ph - wy : wh;

	if (ww < 2 || wh < 2) return;

	if (cw->log.scrolled)
	{
		pmap = XCreatePixmap(dpy , XtWindow(w) , ww , wh , 
			DefaultDepthOfScreen(DefaultScreenOfDisplay(dpy)));

		XSetForeground(dpy , cw->log.gc , cw->core.background_pixel);
		XFillRectangle(dpy , pmap , cw->log.gc , 0 , 0 , ww ,wh);
	}
	else
	{
		pmap = XtWindow(w);
	}

	y = cw->log.spacing + cw->log.topy;

	XSetForeground(dpy , cw->log.gc , cw->base.foreground);

	for (p = cw->log.first ; p ; p = p->next , 
				     y += cw->log.font->ascent + cw->log.font->descent)
	{
		if (y > (int)wh) break;

		if ((y + cw->log.font->descent + cw->log.font->ascent) > 0)
			XDrawString(dpy , pmap , cw->log.gc , cw->log.spacing  + cw->log.topx , 
				y + cw->log.font->ascent , p->entry ,strlen(p->entry));
	}

	if (cw->log.scrolled)	
	{
		XCopyArea(dpy , pmap , XtWindow(w) , cw->log.gc ,
			0 , 0 , ww , wh , 0 , 0);
	        XFreePixmap(dpy , pmap);
	}
}

#define WidgetValuesDiffer(w1,w2,component) (w1 -> log.component != \
                                             w2 -> log.component)


static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args;
{
	LogWidget cw = (LogWidget) current;
	LogWidget nw = (LogWidget) new_widget;
	Boolean redraw = False;

	return redraw;
}

static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
	LogWidget cw = (LogWidget) w;
        unsigned int width = 0, height = 0;
	Dimension pwidth,pheight,lwidth;
	Position x,y;
	StrList *p;

        logClassRec.base_class.get_internal_dimension
        		(w , &x , &y , &pwidth , &pheight);

        preferred->width = cw->core.width - pwidth;
        preferred->height = cw->core.height - pheight;
        preferred->request_mode = CWWidth | CWHeight;


	for(p = cw->log.first ; p ; p = p->next)
	{
		lwidth = XTextWidth(cw->log.font , p->entry , strlen(p->entry));
		width = MAX(width , lwidth);
		height += cw->log.font->ascent + 
			cw->log.font->descent;
        }

        preferred->width = MAX(preferred->width , width + 2 * cw->log.spacing);
        preferred->height = MAX( preferred->height , height + 2 * cw->log.spacing);

	if (((intended->request_mode & (CWWidth | CWHeight))
                == (CWWidth | CWHeight)) &&
                intended->width == preferred->width &&
                intended->height == preferred->height)
                return XtGeometryYes;

        else if (preferred->width == cw->core.width &&
                preferred->height == cw->core.height)

        return XtGeometryNo;

        else return XtGeometryAlmost;
}

static void Selecting (w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	LogWidget cw = (LogWidget) w;
}

static void Select(w, event, params, num_params)
Widget w;
XEvent *event;
String *params;
Cardinal *num_params;
{
	LogWidget cw = (LogWidget) w;
}

void LogAppendLine(w,line)
Widget w;
char *line;
{
	LogWidget cw = (LogWidget) w;
	StrList *p;

	if (cw->log.last)
	{
		cw->log.last->next = malloc(sizeof(StrList));
		cw->log.last = cw->log.last->next;
		cw->log.last->next = NULL;
		cw->log.last->entry = XtNewString(line);
	}
	else
	{
		cw->log.first = cw->log.last = malloc(sizeof(StrList));
		cw->log.last->next = NULL;
		cw->log.last->entry = XtNewString(line);		
	}

	cw->log.numlines ++;

	if (cw->log.maxlines && (cw->log.numlines > cw->log.maxlines))
	{
		cw->log.numlines--;

		p = cw->log.first;
		cw->log.first = cw->log.first->next;

		XtFree(p->entry);
		XtFree((char *) p);

		if (!cw->log.first) cw->log.last = NULL;
	}

	SetSW(w);
}

static void SetSW(w)
LogWidget w;
{
        int height = 0 , width = 0 , lwidth;
	StrList *p;


	height = w->log.numlines * (w->log.font->ascent + w->log.font->descent);
	height += 2 * w->log.spacing;

        if (w->log.scrolled)
        {
		for(p = w->log.first ; p ; p = p->next)
		{
			lwidth = XTextWidth(w->log.font , p->entry , strlen(p->entry));
			width = MAX(width , lwidth);
	        }

                width += 2 * w->log.spacing;

                SetScrollWin(XtParent(w) , XtCchild_width , width ,
                			   XtCchild_height , height ,
                			   w->log.bottom_grav ? XtCbottom_border : 0 , height , 0);
        }
}

static void Wscrl(w,client_data,call_data)
Widget w;
XtPointer client_data;
XtPointer call_data;
{
        ScrollWinInfo *p= (ScrollWinInfo *) call_data;
	LogWidget cw = (LogWidget) client_data;

	cw->log.topx = p->x;
	cw->log.topy = p->y;
	
	Redisplay((Widget)cw , NULL , NULL);	
}

void LogClear(w)
Widget w;
{
	LogWidget cw = (LogWidget) w;
	StrList *p;

	while(cw->log.first)
	{
		p = cw->log.first->next;
		free(cw->log.first);
		cw->log.first = p;
	}

	cw->log.first = NULL;
	cw->log.last = NULL;
	cw->log.numlines = 0;

	SetSW(w);
	Redisplay((Widget)cw , NULL , NULL);
}
