/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#ifndef _cvt_h_
#define _cvt_h_

#include <X11/Xlib.h>
#include <X11/xpm.h>

#ifndef XtRBox_type
#define XtRBox_type	"Box_type"
#endif

#ifndef XtRJustify
#define XtRJustify	"Justify"
#endif

#ifndef XtRIcon
#define XtRIcon		"Icon"
#endif

#ifndef XtRCheck_type
#define XtRCheck_type		"Check_type"
#endif

#ifndef XtRObject_type
#define XtRObject_type		"Object_type"
#endif

#ifndef XtROrientation
#define XtROrientation		"Orientation"
#endif

#ifndef XtRListStruct
#define XtRListStruct		"ListStruct"
#endif

#ifndef XtRButtonMode
#define XtRButtonMode		"ButtonMode"
#endif

#ifndef XtRStringList
#define XtRStringList		"StringList"
#endif

/* constant for box type definition */
#define XtCno_box 		0
#define XtCsimple_box		1
#define XtCup_box		2
#define XtCdown_box		3
#define XtCframein_box		4
#define XtCframeout_box		5
#define XtCshadow_box		6

/* constant for justifycation definition */
#define XtCcenter		0
#define XtCright		1
#define XtCleft			2
#define XtCbottom		3
#define XtCtop			4

/* constant for check type definition */
#define XtCcheck		0
#define XtCcircle		1
#define XtCrectangle		2
#define XtCdiamond		3
#define XtCcross		4
#define XtCcircle2		5

/* constant for object type definition */
#define XtCright_arrow		0
#define XtCleft_arrow		1
#define XtCtop_arrow		2
#define XtCbottom_arrow		3

/* constant for orientation definition */
#define XtCvertical		0
#define XtChorizontal		1

/* button mode constants */
#define XtCnormalMode	0
#define XtCcyclicMode	1
#define	XtCtoggleMode	2

typedef struct {
	Pixmap		pixmap;
	Pixmap		shape;
	unsigned int	width;
	unsigned int	height;
} Icon;

typedef struct {
	int		index;
	char		*label;
	Icon		*left_icon;
	Icon		*right_icon;
	Boolean		sensitive;
	void		*related_info;
} ListStruct;

#if  NeedFunctionPrototypes
extern Boolean  cvtStringToStringList(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
extern Boolean  cvtStringToBoxType(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
extern Boolean  cvtBoxTypeToString(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
extern Boolean  cvtStringToJustify(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
extern Boolean  cvtStringToIcon(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
extern Boolean  cvtStringToCheckType(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
extern Boolean  cvtStringToObjectType(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
extern Boolean  cvtStringToOrientation(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
extern Boolean  cvtStringToListStruct(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
extern Boolean  cvtStringToButtonMode(Display *,XrmValuePtr,Cardinal *,XrmValuePtr,XrmValuePtr,XtPointer *);
#else
extern Boolean  cvtStringToStringList();
extern Boolean  cvtStringToBoxType();
extern Boolean  cvtBoxTypeToString();
extern Boolean  cvtStringToJustify();
extern Boolean  cvtStringToIcon();
extern Boolean  cvtStringToCheckType();
extern Boolean  cvtStringToObjectType();
extern Boolean  cvtStringToOrientation();
extern Boolean  cvtStringToListStruct();
extern Boolean  cvtStringToButtonMode();
#endif


#define done(type, value) do {\
	if (to->addr != NULL) {\
		if (to->size < sizeof(type)) {\
			to->size = sizeof(type);\
			return False;\
		}\
		*(type*)(to->addr) = (value);\
	} else {\
		static type static_val;\
		static_val = (value);\
		to->addr = (XtPointer)&static_val;\
	}\
	to->size = sizeof(type);\
	return True;\
    }while (0 )

#endif
