/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/wait.h>
#include <signal.h>

#include "config.h"
#include "tools.h"

typedef struct {
	char	*h_name;
	int	h_length;
	char	*h_addres;
} dns_entry;

typedef struct {
	int num;
	dns_entry *e;
} htab_entry;

#define DNS_HASH_NUM 50
static htab_entry dns_htab[DNS_HASH_NUM];
static pid_t dns_pid = 0;
static bufio *dns_w = NULL;
static bufio *dns_r = NULL;

#ifdef I_FACE

static void dns_serv_loop(in , out)
bufio *in;
bufio *out;
{
	struct hostent * host;
	int serno;
	char buf[1024];
	int pom;
	int len;

	cfg.xi_face = FALSE;
	cfg.ctimeout = 0;

	for (;;)
	{	
		if ((len = bufio_read(in , (char *)&serno , sizeof(serno))) != sizeof(serno))
		{
			if (len) perror("dns server - protokol error");
			else printf("dns server - client exited\n");
			exit(1);
		}

		if ((len = bufio_readln(in , (char *)buf , sizeof(buf))) < 0)
		{
			if (len) perror("dns server - protokol error");
			else printf("dns server - client exited\n");
			exit(1);
		}
		strip_nl(buf);

		if ((host = gethostbyname(buf)))
		{
			pom = 0;
			bufio_write(out , (char *)&pom , sizeof(pom));
			bufio_write(out , (char *)&serno , sizeof(serno));
			bufio_write(out , (char *)&host->h_length , sizeof(host->h_length));
			bufio_write(out ,  (char *)host->h_addr , host->h_length);
		}
		else
		{
			pom = -1;
			bufio_write(out , (char *)&pom , sizeof(pom));
			bufio_write(out , (char *)&serno , sizeof(serno));
			bufio_write(out , (char *)&errno , sizeof(errno));
			bufio_write(out , (char *)&h_errno , sizeof(h_errno));
		}
	}
}

int dns_serv_start()
{
	int cfd[2];
	int sfd[2];
	int i;

	for (i = 0 ; i < DNS_HASH_NUM ; i++)
	{
		dns_htab[i].num = 0;
		dns_htab[i].e = NULL;
	}

	if (pipe(cfd))
	{
		xperror("pipe");
		return -1;
	}

	if (pipe(sfd))
	{
		xperror("pipe");
		close(cfd[0]);
		close(cfd[1]);
		return -1;
	}

	if (!(dns_pid = fork()))
	{
		/* child */
		close(sfd[0]);
		close(cfd[1]);
		dns_serv_loop(bufio_fdopen(cfd[0]) , bufio_fdopen(sfd[1]));
		exit(0);
	}

	if (dns_pid < 0)
	{
		xperror("fork");
		close(cfd[0]);
		close(cfd[1]);
		close(sfd[0]);
		close(sfd[1]);
		return -1;
	}

	setpgid(0 , dns_pid);

	close(sfd[1]);
	close(cfd[0]);

	dns_w = bufio_fdopen(cfd[1]);
	dns_r = bufio_fdopen(sfd[0]);
	dns_pid = dns_pid;

	return 0;
}

void dns_server_kill()
{
	if (dns_pid)
	{
		kill(dns_pid , 15);
		waitpid(dns_pid , NULL , 0);
		bufio_close(dns_w);
		bufio_close(dns_r);
		dns_pid = 0;
		dns_w = NULL;
		dns_r = NULL;
	}
}

static int dns_cli_gethostbyname(host , len , addr)
char *host;
int *len;
char *addr;
{
	static int serno = 0;
	int rserno;
	int retc;
	int alen;
	char abuf[64];

	serno++;

	/* need to use unbreakable write because of protocol consistency */
	write(bufio_getfd(dns_w) , (char *)&serno , sizeof(serno));
	write(bufio_getfd(dns_w) , (char *)host , strlen(host));
	write(bufio_getfd(dns_w) , "\n" , 1);

	/* !!!!!! should use other method with only one read - protocol consistency on user break !!!!! */
	do
	{
		if (cfg.rbreak)
		{
			errno = EINTR;
			return -1;	
		}
		if (bufio_read(dns_r , (char *)&retc , sizeof(retc)) != sizeof(retc))
		{
			xperror("dns client protocol error");
			return -1;
		}

		if (retc)
		{
			if (bufio_read(dns_r , (char *)&rserno , sizeof(rserno)) != sizeof(rserno))
			{
				xperror("dns client protocol error");
				return -1;
			}

			if (bufio_read(dns_r , (char *)&errno , sizeof(errno)) != sizeof(errno))
			{
				xperror("dns client protocol error");
				return -1;
			}

			if (bufio_read(dns_r , (char *)&h_errno , sizeof(h_errno)) != sizeof(errno))
			{
				h_errno = 0;
				xperror("dns client protocol error");
				return -1;
			}

			return -1;
		}

		if (bufio_read(dns_r , (char *)&rserno , sizeof(rserno)) != sizeof(rserno))
		{
			xperror("dns client protocol error");
			return -1;
		}

		if (bufio_read(dns_r , (char *)&alen , sizeof(alen)) != sizeof(alen))
		{
			xperror("dns client protocol error");
			return -1;
		}

		if (bufio_read(dns_r , (char *)abuf , alen) != alen)
		{
			xperror("dns client protocol error");
			return -1;
		}

		memcpy(addr , abuf , alen);
		*len = alen;
		return 0;

	} while (serno > rserno);

	if (rserno != serno) return -1;

}
#endif /* I_FACE */

int dns_gethostbyname(name , alen , addr)
char *name;
int *alen;
char *addr;
{
	struct hostent *host;
	int ret;
	int i;
	unsigned int hpos;

	LOCK_DNS
	hpos = hash_func(name , DNS_HASH_NUM);

	for (i = 0 ; i < dns_htab[hpos].num ; i++)
	{
		if (!strcasecmp(dns_htab[hpos].e[i].h_name , name))
		{
			*alen = dns_htab[hpos].e[i].h_length;
			memcpy(addr , dns_htab[hpos].e[i].h_addres , 
				dns_htab[hpos].e[i].h_length);
			UNLOCK_DNS
			return 0;
		}
	}
#ifdef I_FACE
	if (dns_pid)
	{
		ret = dns_cli_gethostbyname(name , alen , addr);
	}
	else
#endif
	{
		if ((host = gethostbyname(name)))
		{
			h_errno = 0;
			*alen = host->h_length;
			memcpy(addr , host->h_addr , host->h_length);
			ret = 0;
		}
		else
			ret = -1;
	}

	if (!ret)
	{
		dns_htab[hpos].num++;
		dns_htab[hpos].e = _realloc(dns_htab[hpos].e , 
			dns_htab[hpos].num * sizeof(dns_entry));
		dns_htab[hpos].e[dns_htab[hpos].num - 1].h_name = new_string(name);
		dns_htab[hpos].e[dns_htab[hpos].num - 1].h_length = *alen;
		dns_htab[hpos].e[dns_htab[hpos].num - 1].h_addres = _malloc(*alen);
		memcpy(dns_htab[hpos].e[dns_htab[hpos].num - 1].h_addres , 
			addr , *alen);
	}
	UNLOCK_DNS

	return ret;
}

void dns_free_tab()
{
	int i,j;

	LOCK_DNS
	for (i = 0; i < DNS_HASH_NUM ; i++)
	{
		for(j = 0; j < dns_htab[i].num ; j++)
		{
			_free(dns_htab[i].e[j].h_name);
			_free(dns_htab[i].e[j].h_addres);
		} 
		_free(dns_htab[i].e);
	}
	UNLOCK_DNS
}

