/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/


#include <string.h>
#include "config.h"

#ifdef I_FACE
#include "tools.h"

#include "xpm/audio.xpm"
#include "xpm/binary.xpm"
#include "xpm/html.xpm"
#include "xpm/image.xpm"
#include "xpm/video.xpm"
#include "xpm/text.xpm"
#include "xpm/gopherdir.xpm"
#include "xpm/ftpdir.xpm"
#include "xpm/broken.xpm"
#include "xpm/redirected.xpm"
#include "xpm/rejected.xpm"
#include "xpm/notprocessed.xpm"
#include "xpm/cantaccess.xpm"
#include "xpm/incomplete.xpm"
#include "xpm/local.xpm"
#include "xpm/compressed.xpm"

void icons_set_for_doc(docp)
doc *docp;
{
#ifdef WITH_TREE
	Icon *icn;
	int i;

	icn = cfg.icon.binary;

	if (docp->doc_url->status & URL_MOVED)
		icn = cfg.icon.redirected;
	else if (docp->doc_url->status & URL_TRUNCATED)
		icn = cfg.icon.incomplete;
	else if (docp->doc_url->status & URL_REJECTED)
		icn = cfg.icon.rejected;
	else if ((docp->doc_url->status & URL_NOT_FOUND) ||
		(docp->doc_url->status & URL_ERR_UNREC))
		icn = cfg.icon.broken;
	else if (docp->doc_url->status & URL_ERR_REC)
		icn = cfg.icon.cantaccess;
	else if ((docp->doc_url->type == URLT_FTP || docp->doc_url->type == URLT_FTPS) && docp->doc_url->p.ftp.dir)
		icn = cfg.icon.ftpdir;
	else if ((docp->doc_url->type == URLT_GOPHER) &&
		(docp->doc_url->p.gopher.selector[0] == 'I'))
		icn = cfg.icon.image;
	else if ((docp->doc_url->type == URLT_GOPHER) &&
		(docp->doc_url->p.gopher.selector[0] == '0'))
		icn = cfg.icon.text;
	else if ((docp->doc_url->type == URLT_GOPHER) &&
		(docp->doc_url->p.gopher.selector[0] == '1'))
		icn = cfg.icon.gopherdir;
	else if (docp->type_str)
	{
		if (!strcasecmp(docp->type_str , "text/html"))
			icn = cfg.icon.html;
		else if (!strncasecmp(docp->type_str , "text/" , 5))
			icn = cfg.icon.text;
		else if (!strncasecmp(docp->type_str , "audio/" , 6))
			icn = cfg.icon.audio;
		else if (!strncasecmp(docp->type_str , "image/" , 6))
			icn = cfg.icon.image;
		else if (!strncasecmp(docp->type_str , "video/" , 6))
			icn = cfg.icon.video;
		else if (str_is_in_list(0 , get_extension(url_get_path(docp->doc_url)) , 
			"gz" , "arj" , "zip" , "lha" , "pak" , "lzh" , "bz" , "bz2" , "rar" , "uc2" , "ha" , "tgz" , NULL))
			icn = cfg.icon.compressed;
		else icn = cfg.icon.binary;
	}
	else if (str_is_in_list(0 , get_extension(url_get_path(docp->doc_url)) ,
		"html" , "htm" , "shtml" , "phtml" , NULL))
		icn = cfg.icon.html;
	else if (str_is_in_list(0 , get_extension(url_get_path(docp->doc_url)) ,
		"txt" , NULL))
		icn = cfg.icon.text;
	else if (str_is_in_list(0 , get_extension(url_get_path(docp->doc_url)) ,
		"mov" , "avi" , "mpg" , "mpeg" , "fli" , "flc" , NULL))
		icn = cfg.icon.video;
	else if (str_is_in_list(0 , get_extension(url_get_path(docp->doc_url)) ,
		"jpg" , "jpeg" , "png" , "gif" , "bmp" , "pic" , "ppm" , "pbm" , "pgm" , "pnm" , "xbm " , "xpm" , NULL))
		icn = cfg.icon.image;
	else if (str_is_in_list(0 , get_extension(url_get_path(docp->doc_url)) ,
		"voc" , "au" , "wav" , "midi" , "mp3" , NULL))
		icn = cfg.icon.audio;
	else if (str_is_in_list(0 , get_extension(url_get_path(docp->doc_url)) , 
		"gz" , "arj" , "zip" , "lha" , "pak" , "lzh" , "bz" , "bz2" , "rar" , "uc2" , "ha" , "tgz" , NULL))
		icn = cfg.icon.compressed;
	else if ((docp->doc_url->type == URLT_FILE) ||
		(docp->doc_url->status & URL_REDIRECT))
		icn = cfg.icon.local;

	for (i = 0 ; i < docp->doc_url->ref_cnt ; i ++)
#ifdef X_FACE
		TreeListItemSetIcon(cfg.X.tree_widget , docp->doc_url->tree_nfo[i] , icn);
#endif
#ifdef GTK_FACE
	{
#ifdef _GTK_FEATURES_1_2
		char *p = url_to_urlstr(docp->doc_url , FALSE);

		gtk_ctree_set_node_info(GTK_CTREE(cfg.gtk.tree_widget) ,
			docp->doc_url->tree_nfo[i] , p , 8 ,
			icn->pixmap , icn->shape ,
			icn->pixmap , icn->shape , FALSE , TRUE);

		_free(p);
#else
		GtkWidget *pbox;
		GtkPixmap *ppmap = NULL;
		GList *chlist;

		ppmap = NULL;

		pbox = GTK_BIN(docp->doc_url->tree_nfo[i])->child;

		for (chlist = GTK_BOX(pbox)->children ; chlist ; chlist = chlist->next)
		{
			if (GTK_IS_PIXMAP(((struct _GtkBoxChild *)chlist->data)->widget))
			{
				ppmap = GTK_PIXMAP(((struct _GtkBoxChild *)chlist->data)->widget);
				break;
			}
		}
		gtk_pixmap_set(ppmap , icn->pixmap , icn->shape);
#endif
	}
#endif
	_Xt_Serve
#endif
}

void icons_load()
{
#ifdef WITH_TREE
	cfg.icon.audio = iface_load_xpm_icon(audio_xpm);
	cfg.icon.binary = iface_load_xpm_icon(binary_xpm);
	cfg.icon.html = iface_load_xpm_icon(html_xpm);
	cfg.icon.image = iface_load_xpm_icon(image_xpm);
	cfg.icon.video = iface_load_xpm_icon(video_xpm);
	cfg.icon.text = iface_load_xpm_icon(text_xpm);
	cfg.icon.gopherdir = iface_load_xpm_icon(gopherdir_xpm);
	cfg.icon.ftpdir = iface_load_xpm_icon(ftpdir_xpm);
	cfg.icon.broken = iface_load_xpm_icon(broken_xpm);
	cfg.icon.redirected = iface_load_xpm_icon(redirected_xpm);
	cfg.icon.rejected = iface_load_xpm_icon(rejected_xpm);
	cfg.icon.notprocessed = iface_load_xpm_icon(notprocessed_xpm);
	cfg.icon.cantaccess = iface_load_xpm_icon(cantaccess_xpm);
	cfg.icon.incomplete = iface_load_xpm_icon(incomplete_xpm);
	cfg.icon.local = iface_load_xpm_icon(local_xpm);
	cfg.icon.compressed = iface_load_xpm_icon(compressed_xpm);
#endif
}

#endif
