//
//  main_window.c  --  the basic window of Althea
//  -- created 5/23/00  updated 5/23/00
///////////////////////////////////////////

#include "main_window.h"

extern Althea gAlthea;

GtkWidget*
create_main_window (void)
{




  GtkTargetEntry index_drag_types[] = {
    {"x-application/x-message-list", GTK_TARGET_SAME_APP, TARGET_MESSAGES}
  };
  GtkTargetEntry folder_list_drop_types[] = {
    {"x-application/x-message-list", GTK_TARGET_SAME_APP, TARGET_MESSAGES}
  };







  GtkAccelGroup *menu_accel_group;

  GtkWidget *main_window;
  GtkWidget *vbox1;
  GtkWidget *main_menu;

  // ALTHEA MENU
  GtkWidget *althea_menu;
  GtkWidget *althea_menu_menu;
  GtkAccelGroup *althea_menu_menu_accels;
  GtkWidget *althea_check_mail;
  GtkWidget *althea_options;
  GtkWidget *althea_sep1;
  GtkWidget *althea_exit;

  // EDIT MENU -- Not implemented yet.
/*
  GtkWidget *edit_menu;
  GtkWidget *edit_menu_menu;
  GtkAccelGroup *edit_menu_menu_accels;
  GtkWidget *edit_copy;
  GtkWidget *edit_cut;
  GtkWidget *edit_paste;
  GtkWidget *edit_sep1;
  GtkWidget *edit_clear;
  GtkWidget *edit_select_all;
*/

  // MESSAGE MENU
  GtkWidget *message_menu;
  GtkWidget *message_menu_menu;
  GtkAccelGroup *message_menu_menu_accels;
  GtkWidget *message_new;
  GtkWidget *message_save;
  GtkWidget *message_reply;
  GtkWidget *message_reply_all;
  GtkWidget *message_forward;
  GtkWidget *message_print;
  GtkWidget *message_delete;
  GtkWidget *message_undelete;
  GtkWidget *message_expunge;
  GtkWidget *message_full_header;
  //GtkWidget *message_sep1;
  //GtkWidget *message_move_to_folder;

  // ADDRESS BOOK MENU -- Not implemented yet
/*
  GtkWidget *address_book_menu;
  GtkWidget *address_book_menu_menu;
  GtkAccelGroup *address_book_menu_menu_accels;
  GtkWidget *address_book_view;
  GtkWidget *address_book_add;
  GtkWidget *address_book_sep1;
  GtkWidget *address_book_import;
  GtkWidget *address_book_export;
*/

  // SEARCH MENU -- Not implemented yet.
/*
  GtkWidget *search_menu;
  GtkWidget *search_menu_menu;
  GtkAccelGroup *search_menu_menu_accels;
  GtkWidget *search_message;
  GtkWidget *search_folders;
  GtkWidget *search_again;
  GtkWidget *search_sep1;
  GtkWidget *search_advanced;
*/

  // HELP MENU
  GtkWidget *help_menu;
  GtkWidget *help_menu_menu;
  GtkAccelGroup *help_menu_menu_accels;
//  GtkWidget *help_index;
  GtkWidget *help_contents;
  GtkWidget *help_about;

  // TOOLBAR
  GtkWidget *handlebox;
  GtkWidget *toolbar;
  GtkWidget *new_message;
  GtkWidget *save_message;
  GtkWidget *print_message;
  GtkWidget *reply_to_message;
  GtkWidget *reply_all_to_message;
  //GtkWidget *address_book;
  GtkWidget *check_mail;
  GtkWidget *delete_mail;
  GtkWidget *forward_message;

  // MESSAGE PANE(S)
  GtkWidget *hbox1;
  GtkWidget *hpaned1;
  GtkWidget *scrolledwindow3;
  GtkWidget *viewport1;
  GtkWidget *folder_list;
  GtkWidget *vpaned1;
  GtkWidget *scrolledwindow4;
  GtkWidget *message_list;
  GtkWidget *from_label;
  GtkWidget *subject_label;
  GtkWidget *date_label;
  GtkWidget *status_label;
  GtkWidget *scrolledwindow5;
  GtkWidget *message_text;


  // BUILD MAIN WINDOW
  main_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (main_window), "main_window", main_window);
  gtk_widget_set_usize (main_window, 700, 550);
  string version_string = *new string();
  version_string = _("Althea v");
  version_string += VERSION;
  gtk_window_set_title (GTK_WINDOW (main_window), version_string.c_str());
  gtk_window_set_position (GTK_WINDOW (main_window), GTK_WIN_POS_CENTER);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_ref (vbox1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "vbox1", vbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vbox1);
  gtk_container_add (GTK_CONTAINER (main_window), vbox1);
  gtk_widget_set_usize (vbox1, 600, 450);


  // BUILD MENU BAR
  main_menu = gtk_menu_bar_new ();
  gtk_widget_ref (main_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "main_menu", main_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (main_menu);
  gtk_box_pack_start (GTK_BOX (vbox1), main_menu, FALSE, FALSE, 0);


  // BUILD ALTHEA MENU
  althea_menu = gtk_menu_item_new_with_label (_("Althea"));
  gtk_widget_ref (althea_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "althea_menu", althea_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (althea_menu);
  gtk_container_add (GTK_CONTAINER (main_menu), althea_menu);

  althea_menu_menu = gtk_menu_new ();
  gtk_widget_ref (althea_menu_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "althea_menu_menu",
			    althea_menu_menu, (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (althea_menu), althea_menu_menu);
  althea_menu_menu_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU
							     (althea_menu_menu));


  althea_check_mail = gtk_menu_item_new_with_label (_("Check Mail"));
  gtk_widget_ref (althea_check_mail);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "althea_check_mail",
			    althea_check_mail,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (althea_check_mail);
  gtk_container_add (GTK_CONTAINER (althea_menu_menu), althea_check_mail);

  althea_options = gtk_menu_item_new_with_label (_("Setup..."));
  gtk_widget_ref (althea_options);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "althea_options",
			    althea_options,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (althea_options);
  gtk_container_add (GTK_CONTAINER (althea_menu_menu), althea_options);
  
  althea_sep1 = gtk_menu_item_new ();
  gtk_widget_ref (althea_sep1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "althea_sep1", althea_sep1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (althea_sep1);
  gtk_container_add (GTK_CONTAINER (althea_menu_menu), althea_sep1);
  gtk_widget_set_sensitive (althea_sep1, FALSE);

  althea_exit = gtk_menu_item_new_with_label (_("Exit"));
  gtk_widget_ref (althea_exit);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "althea_exit", althea_exit,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (althea_exit);
  gtk_container_add (GTK_CONTAINER (althea_menu_menu), althea_exit);

  // END OF BUILD ALTHEA MENU


  // BUILD EDIT MENU -- Not implemented yet
/*
  edit_menu = gtk_menu_item_new_with_label ("Edit");
  gtk_widget_ref (edit_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "edit_menu", edit_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_menu);
  gtk_container_add (GTK_CONTAINER (main_menu), edit_menu);

  edit_menu_menu = gtk_menu_new ();
  gtk_widget_ref (edit_menu_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "edit_menu_menu",
			    edit_menu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (edit_menu), edit_menu_menu);
  edit_menu_menu_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU
							     (edit_menu_menu));

  edit_copy = gtk_menu_item_new_with_label ("Copy");
  gtk_widget_ref (edit_copy);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "edit_copy", edit_copy,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_copy);
  gtk_container_add (GTK_CONTAINER (edit_menu_menu), edit_copy);

  edit_cut = gtk_menu_item_new_with_label ("Cut");
  gtk_widget_ref (edit_cut);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "edit_cut", edit_cut,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_cut);
  gtk_container_add (GTK_CONTAINER (edit_menu_menu), edit_cut);

  edit_paste = gtk_menu_item_new_with_label ("Paste");
  gtk_widget_ref (edit_paste);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "edit_paste", edit_paste,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_paste);
  gtk_container_add (GTK_CONTAINER (edit_menu_menu), edit_paste);

  edit_sep1 = gtk_menu_item_new ();
  gtk_widget_ref (edit_sep1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "edit_sep1", edit_sep1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_sep1);
  gtk_container_add (GTK_CONTAINER (edit_menu_menu), edit_sep1);
  gtk_widget_set_sensitive (edit_sep1, FALSE);

  edit_clear = gtk_menu_item_new_with_label ("Clear");
  gtk_widget_ref (edit_clear);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "edit_clear", edit_clear,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_clear);
  gtk_container_add (GTK_CONTAINER (edit_menu_menu), edit_clear);

  edit_select_all = gtk_menu_item_new_with_label ("Select All");
  gtk_widget_ref (edit_select_all);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "edit_select_all",
			    edit_select_all,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (edit_select_all);
  gtk_container_add (GTK_CONTAINER (edit_menu_menu), edit_select_all);
*/
  // END BUILD EDIT MENU


  // BUILD MESSAGE MENU
  message_menu = gtk_menu_item_new_with_label (_("Message"));
  gtk_widget_ref (message_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_menu",
			    message_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_menu);
  gtk_container_add (GTK_CONTAINER (main_menu), message_menu);

  message_menu_menu = gtk_menu_new ();
  gtk_widget_ref (message_menu_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_menu_menu",
			    message_menu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (message_menu), message_menu_menu);
  message_menu_menu_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (message_menu_menu));

  message_new = gtk_menu_item_new_with_label (_("New Message..."));
  gtk_widget_ref (message_new);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_new",
			    message_new,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_new);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_new);

  message_save = gtk_menu_item_new_with_label (_("Save Message..."));
  gtk_widget_ref (message_save);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_save",
			    message_save,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_save);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_save);

  message_reply = gtk_menu_item_new_with_label (_("Reply..."));
  gtk_widget_ref (message_reply);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_reply",
			    message_reply,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_reply);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_reply);

  message_reply_all = gtk_menu_item_new_with_label (_("Reply All..."));
  gtk_widget_ref (message_reply_all);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_reply_all",
			    message_reply_all,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_reply_all);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_reply_all);

  message_forward = gtk_menu_item_new_with_label (_("Forward..."));
  gtk_widget_ref (message_forward);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_forward",
			    message_forward,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_forward);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_forward);

  message_print = gtk_menu_item_new_with_label (_("Print..."));
  gtk_widget_ref (message_print);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_print",
			    message_print,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_print);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_print);

  message_delete = gtk_menu_item_new_with_label (_("Delete"));
  gtk_widget_ref (message_delete);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_delete",
			    message_delete,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_delete);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_delete);

  message_undelete = gtk_menu_item_new_with_label (_("Undelete"));
  gtk_widget_ref (message_undelete);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_undelete",
			    message_undelete,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_undelete);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_undelete);

  message_expunge = gtk_menu_item_new_with_label (_("Expunge"));
  gtk_widget_ref (message_expunge);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_expunge",
			    message_expunge,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_expunge);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_expunge);

  message_full_header = gtk_menu_item_new_with_label (_("Show Full Header"));
  gtk_widget_ref (message_full_header);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_full_header",
			    message_full_header,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_full_header);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_full_header);
  
/* Place back in when moving to folders is implemented
  message_sep1 = gtk_menu_item_new ();
  gtk_widget_ref (message_sep1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_sep1", message_sep1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_sep1);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_sep1);
  gtk_widget_set_sensitive (message_sep1, FALSE);

  message_move_to_folder = gtk_menu_item_new_with_label ("Move to Folder");
  gtk_widget_ref (message_move_to_folder);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_move_to_folder",
			    message_move_to_folder,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (message_move_to_folder);
  gtk_container_add (GTK_CONTAINER (message_menu_menu), message_move_to_folder);
*/
  // END BUILD MESSAGE MENU


  // BUILD ADDRESS BOOK MENU -- Not implemented yet
/*
  address_book_menu = gtk_menu_item_new_with_label ("Address Book");
  gtk_widget_ref (address_book_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "address_book_menu",
			    address_book_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (address_book_menu);
  gtk_container_add (GTK_CONTAINER (main_menu), address_book_menu);

  address_book_menu_menu = gtk_menu_new ();
  gtk_widget_ref (address_book_menu_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "address_book_menu_menu",
			    address_book_menu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (address_book_menu),
			     address_book_menu_menu);
  address_book_menu_menu_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (address_book_menu_menu));

  address_book_view = gtk_menu_item_new_with_label ("View");
  gtk_widget_ref (address_book_view);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "address_book_view",
			    address_book_view,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (address_book_view);
  gtk_container_add (GTK_CONTAINER (address_book_menu_menu), address_book_view);

  address_book_add = gtk_menu_item_new_with_label ("Add an Address");
  gtk_widget_ref (address_book_add);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "address_book_add",
			    address_book_add,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (address_book_add);
  gtk_container_add(GTK_CONTAINER (address_book_menu_menu), address_book_add);

  address_book_sep1 = gtk_menu_item_new ();
  gtk_widget_ref (address_book_sep1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "address_book_sep1", address_book_sep1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (address_book_sep1);
  gtk_container_add (GTK_CONTAINER (address_book_menu_menu), address_book_sep1);
  gtk_widget_set_sensitive (address_book_sep1, FALSE);

  address_book_import = gtk_menu_item_new_with_label ("Import");
  gtk_widget_ref (address_book_import);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "address_book_import",
			    address_book_import,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (address_book_import);
  gtk_container_add(GTK_CONTAINER (address_book_menu_menu), address_book_import);

  address_book_export = gtk_menu_item_new_with_label ("Export");
  gtk_widget_ref (address_book_export);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "address_book_export",
			    address_book_export,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (address_book_export);
  gtk_container_add(GTK_CONTAINER (address_book_menu_menu), address_book_export);
*/
  // END BUILD ADDRESS BOOK MENU


  // BUILD SEARCH MENU -- Not implemented yet
/*
  search_menu = gtk_menu_item_new_with_label ("Search");
  gtk_widget_ref (search_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "search_menu", search_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_menu);
  gtk_container_add (GTK_CONTAINER (main_menu), search_menu);

  search_menu_menu = gtk_menu_new ();
  gtk_widget_ref (search_menu_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "search_menu_menu",
			    search_menu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (search_menu), search_menu_menu);
  search_menu_menu_accels = gtk_menu_ensure_uline_accel_group(GTK_MENU (search_menu_menu));

  search_message = gtk_menu_item_new_with_label ("Search in Message");
  gtk_widget_ref (search_message);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "search_message",
			    search_message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_message);
  gtk_container_add (GTK_CONTAINER (search_menu_menu), search_message);

  search_folders = gtk_menu_item_new_with_label ("Search in Folders");
  gtk_widget_ref (search_folders);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "search_folders",
			    search_folders,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_folders);
  gtk_container_add (GTK_CONTAINER (search_menu_menu), search_folders);

  search_again = gtk_menu_item_new_with_label ("Search Again");
  gtk_widget_ref (search_again);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "search_again",
			    search_again,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_again);
  gtk_container_add (GTK_CONTAINER (search_menu_menu), search_again);

  search_sep1 = gtk_menu_item_new ();
  gtk_widget_ref (search_sep1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "search_sep1", search_sep1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_sep1);
  gtk_container_add (GTK_CONTAINER (search_menu_menu), search_sep1);
  gtk_widget_set_sensitive (search_sep1, FALSE);

  search_advanced = gtk_menu_item_new_with_label ("Advanced Search");
  gtk_widget_ref (search_advanced);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "search_advanced",
			    search_advanced,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (search_advanced);
  gtk_container_add (GTK_CONTAINER (search_menu_menu), search_advanced);
*/
  // END BUILD SEARCH MENU


  // BUILD HELP MENU
  help_menu = gtk_menu_item_new_with_label (_("Help"));
  gtk_widget_ref (help_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "help_menu", help_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (help_menu);
  gtk_container_add (GTK_CONTAINER (main_menu), help_menu);

  help_menu_menu = gtk_menu_new ();
  gtk_widget_ref (help_menu_menu);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "help_menu_menu",
			    help_menu_menu,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (help_menu), help_menu_menu);
  help_menu_menu_accels = gtk_menu_ensure_uline_accel_group (GTK_MENU (help_menu_menu));

/* No index yet
  help_index = gtk_menu_item_new_with_label ("Index");
  gtk_widget_ref (help_index);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "help_index", help_index,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (help_index);
  gtk_container_add (GTK_CONTAINER (help_menu_menu), help_index);
*/
  help_contents = gtk_menu_item_new_with_label (_("Contents"));
  gtk_widget_ref (help_contents);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "help_contents",
			    help_contents,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (help_contents);
  gtk_container_add (GTK_CONTAINER (help_menu_menu), help_contents);

  help_about = gtk_menu_item_new_with_label (_("About"));
  gtk_widget_ref (help_about);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "help_about", help_about,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (help_about);
  gtk_container_add (GTK_CONTAINER (help_menu_menu), help_about);

  // END BUILD HELP MENU


  // BUILD TOOLBAR

  // First, build handlebox to contain toolbar
  handlebox = gtk_handle_box_new();
  gtk_box_pack_start(GTK_BOX(vbox1), handlebox, FALSE, FALSE, 0);
  gtk_container_set_border_width(GTK_CONTAINER(handlebox), 2);

  // Second, build toolbar
  toolbar = gtk_toolbar_new (GTK_ORIENTATION_HORIZONTAL, GTK_TOOLBAR_BOTH);
  gtk_widget_ref (toolbar);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "toolbar", toolbar,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_toolbar_set_button_relief(GTK_TOOLBAR(toolbar), GTK_RELIEF_NONE);

  gtk_container_add(GTK_CONTAINER(handlebox), toolbar);

  gtk_widget_show(toolbar);
  gtk_widget_show(handlebox);

  // Third, build buttons for toolbar

  // NEW MESSAGE BUTTON
  new_message = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					_("New"),
					_("Write a new message"), NULL,
					create_pixmap(main_window, "new.xpm"),
					NULL, NULL);
  gtk_widget_ref (new_message);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "new_message", new_message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (new_message);


  // SAVE MESSAGE BUTTON
  save_message = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					 _("Save"),
					 _("Save this message to a file"), NULL,
					 create_pixmap(main_window, "save.xpm"),
					 NULL, NULL);
  gtk_widget_ref (save_message);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "save_message",
			    save_message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (save_message);


  // PRINT MESSAGE BUTTON
  print_message = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					  _("Print"),
					  _("Print this message"), NULL,
					  create_pixmap(main_window,"print.xpm"),
					  NULL, NULL);
  gtk_widget_ref (print_message);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "print_message",
			    print_message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (print_message);


  // REPLY TO MESSAGE BUTTON
  reply_to_message = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					     _("Reply"),
					     _("Reply to only the sender of this message"), NULL,
					     create_pixmap(main_window, "reply.xpm"),
					     NULL, NULL);
  gtk_widget_ref (reply_to_message);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "reply_to_message",
			    reply_to_message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (reply_to_message);
  // REPLY All TO MESSAGE BUTTON
  reply_all_to_message = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					     _("Reply All"),
					     _("Reply to all recipients and senders of this message"), NULL,
					     create_pixmap(main_window, "reply.xpm"),
					     NULL, NULL);
  gtk_widget_ref (reply_all_to_message);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "reply_all_to_message",
			    reply_all_to_message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (reply_all_to_message);


  // FORWARD MESSAGE BUTTON
  forward_message = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					    _("Forward"),
					    _("Forward this message to someone else"),
					    NULL,
					    create_pixmap(main_window, "forward.xpm"),
					    NULL, NULL);
  gtk_widget_ref (forward_message);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "forward message",
			    forward_message,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (forward_message);


  // DELETE MESSAGE BUTTON
  delete_mail = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
					_("Delete"),
					_("Delete this message"), NULL,
					create_pixmap(main_window, "delete.xpm"),
					NULL, NULL);
  gtk_widget_ref (delete_mail);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "delete_mail", delete_mail,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (delete_mail);


  // CHECK MAIL BUTTON
  check_mail = gtk_toolbar_append_item(GTK_TOOLBAR (toolbar),
				       _("Check Mail"),
				       _("Check for new mail"), NULL,
				       create_pixmap(main_window, "check.xpm"),
				       NULL, NULL);
  gtk_widget_ref (check_mail);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "check_mail", check_mail,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (check_mail);


  // BUILD MAIN WINDOW PANE
  // containing servers + mailboxes pane (L) and message and index panes (R)

  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox1), hbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 0);

  hpaned1 = gtk_hpaned_new ();
  gtk_widget_ref (hpaned1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "hpaned1", hpaned1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hpaned1);
  gtk_box_pack_start (GTK_BOX (hbox1), hpaned1, TRUE, TRUE, 0);
  gtk_paned_set_handle_size (GTK_PANED (hpaned1), 10);


  // BUILD SERVER+FOLDER LIST PANE
  scrolledwindow3 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_usize( scrolledwindow3, 150, 550 );
  gtk_widget_ref (scrolledwindow3);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "scrolledwindow3",
			    scrolledwindow3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow3);
  gtk_container_add (GTK_CONTAINER (hpaned1), scrolledwindow3);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow3),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);

  viewport1 = gtk_viewport_new (NULL, NULL);
  gtk_widget_ref (viewport1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "viewport1", viewport1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (viewport1);
  gtk_container_add (GTK_CONTAINER (scrolledwindow3), viewport1);
  folder_list = gtk_ctree_new (1,0);
  gtk_clist_set_selection_mode(GTK_CLIST(folder_list),GTK_SELECTION_EXTENDED);
  gtk_ctree_set_line_style(GTK_CTREE(folder_list), GTK_CTREE_LINES_SOLID);
  gtk_ctree_set_expander_style(GTK_CTREE(folder_list),GTK_CTREE_EXPANDER_SQUARE);



  gtk_widget_ref (folder_list);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "folder_list", folder_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (folder_list);
  gtk_container_add (GTK_CONTAINER (viewport1), folder_list);
  // Add it to gAlthea
  gAlthea.set_folder_list( folder_list );

  vpaned1 = gtk_vpaned_new ();
  gtk_widget_ref (vpaned1);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "vpaned1", vpaned1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (vpaned1);
  gtk_container_add (GTK_CONTAINER (hpaned1), vpaned1);
  gtk_paned_set_handle_size (GTK_PANED (vpaned1), 10);


  // BUILD MESSAGE LIST PANE
  scrolledwindow4 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_usize( scrolledwindow4, 750, 150 );
  gtk_widget_ref (scrolledwindow4);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "scrolledwindow4",
			    scrolledwindow4,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow4);
  gtk_container_add (GTK_CONTAINER (vpaned1), scrolledwindow4);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow4),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);

  message_list = gtk_clist_new (4);
  gtk_widget_ref (message_list);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_list",
			    message_list,
                            (GtkDestroyNotify) gtk_widget_unref);
  // Set the selection mode so that only one thing may be selected at a time
  gtk_clist_set_selection_mode( GTK_CLIST (message_list), GTK_SELECTION_SINGLE );
  // Add the message_list to gAlthea
  gAlthea.set_message_list( message_list );
  gtk_widget_show (message_list);
  gtk_container_add (GTK_CONTAINER (scrolledwindow4), message_list);
  gtk_clist_set_column_width (GTK_CLIST (message_list), 0, 100);
  gtk_clist_set_column_width (GTK_CLIST (message_list), 1, 250);
  gtk_clist_set_column_width (GTK_CLIST (message_list), 2, 80);
  gtk_clist_set_column_width (GTK_CLIST (message_list), 3, 40);
  gtk_clist_column_titles_show (GTK_CLIST (message_list));

  from_label = gtk_label_new (_("From"));
  gtk_widget_ref (from_label);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "from_label", from_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (from_label);
  gtk_clist_set_column_widget (GTK_CLIST (message_list), 0, from_label);

  subject_label = gtk_label_new (_("Subject"));
  gtk_widget_ref (subject_label);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "subject_label",
			    subject_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (subject_label);
  gtk_clist_set_column_widget (GTK_CLIST (message_list), 1, subject_label);

  date_label = gtk_label_new (_("Date"));
  gtk_widget_ref (date_label);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "date_label", date_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (date_label);
  gtk_clist_set_column_widget (GTK_CLIST (message_list), 2, date_label);

  status_label = gtk_label_new (_("Status"));
  gtk_widget_ref (status_label);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "status_label",
			    status_label,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (status_label);
  gtk_clist_set_column_widget (GTK_CLIST (message_list), 3, status_label);



  GtkWidget* messvbox= gtk_vbox_new (gboolean FALSE, 0);
  gtk_widget_ref (messvbox);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "messvbox", messvbox,
			    (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (messvbox);
  
  
  
  GtkWidget* attachlist=gtk_list_new();
  gtk_widget_ref (attachlist);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "attachlist", attachlist,
			    (GtkDestroyNotify) gtk_widget_unref);
  //  gtk_widget_set_usize(attachlist,1000,1000);
  
  gtk_widget_show (attachlist);
  
  //add to gAlthea
  gAlthea.set_attach_list( attachlist );
  
  gtk_box_pack_start (GTK_BOX (messvbox), attachlist, FALSE, FALSE, 0);  
  
  
  gtk_container_add (GTK_CONTAINER (vpaned1), messvbox);

 







  // BUILD MESSAGE PANE
  scrolledwindow5 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_ref (scrolledwindow5);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "scrolledwindow5",
			    scrolledwindow5,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (scrolledwindow5);
  //  gtk_container_add (GTK_CONTAINER (vpaned1), scrolledwindow5);

  gtk_box_pack_start (GTK_BOX (messvbox), scrolledwindow5, TRUE, TRUE, 0);


  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow5),
				  GTK_POLICY_AUTOMATIC,
				  GTK_POLICY_AUTOMATIC);

  message_text = gtk_text_new (NULL, NULL);
  gtk_widget_ref (message_text);
  gtk_object_set_data_full (GTK_OBJECT (main_window), "message_text",
			    message_text,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_text_set_word_wrap( GTK_TEXT (message_text), TRUE );
  // Add message_text to gAlthea
  gAlthea.set_message_text( message_text );
  gtk_widget_show (message_text);

  gtk_container_add (GTK_CONTAINER (scrolledwindow5), message_text);


  // SET UP CALLBACKS FOR MENU ITEMS AND BUTTONS

  gtk_signal_connect (GTK_OBJECT (message_expunge), "activate",
                      GTK_SIGNAL_FUNC (on_expunge_menu_activate),
                      NULL);

  gtk_signal_connect (GTK_OBJECT (message_full_header), "activate",
                      GTK_SIGNAL_FUNC (on_full_header_menu_activate),
                      NULL);
  /*
  gtk_signal_connect (GTK_OBJECT (address_book), "clicked",
                      GTK_SIGNAL_FUNC (on_address_book_menu_activate),
                      NULL);
  */
  gtk_signal_connect (GTK_OBJECT (print_message), "clicked",
                      GTK_SIGNAL_FUNC (on_print_message_activate),
                      folder_list );
  gtk_signal_connect (GTK_OBJECT (reply_to_message), "clicked",
		      GTK_SIGNAL_FUNC (on_reply_menu_activate),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (reply_all_to_message), "clicked",
		      GTK_SIGNAL_FUNC (on_reply_all_menu_activate),
		      NULL);
  gtk_signal_connect (GTK_OBJECT (delete_mail), "clicked",
		      GTK_SIGNAL_FUNC (on_delete_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (new_message), "clicked",
                      GTK_SIGNAL_FUNC (on_new_message_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (main_window), "delete_event",
                      GTK_SIGNAL_FUNC (on_main_window_delete_event),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (main_window), "destroy",
                      GTK_SIGNAL_FUNC (on_main_window_destroy),
                      NULL);

  // Althea menu
  gtk_signal_connect (GTK_OBJECT (althea_menu), "activate",
                      GTK_SIGNAL_FUNC (on_althea_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (save_message), "clicked",
                      GTK_SIGNAL_FUNC (on_save_message_menu_activate),
                      NULL );
  gtk_signal_connect (GTK_OBJECT (message_list), "select_row",
                      GTK_SIGNAL_FUNC (on_select_message),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (check_mail), "clicked",
                      GTK_SIGNAL_FUNC (on_check_mail_menu_activate),
                      message_list);

  gtk_signal_connect (GTK_OBJECT (attachlist), "select_child",
		      GTK_SIGNAL_FUNC (on_attach_list_select_child),
		      NULL);
  
  gtk_signal_connect (GTK_OBJECT (althea_check_mail), "activate",
                      GTK_SIGNAL_FUNC (on_check_mail_menu_activate),
                      message_list);
  gtk_signal_connect (GTK_OBJECT (message_print), "activate",
                      GTK_SIGNAL_FUNC (on_print_menu_activate),
                      NULL);
  
  gtk_signal_connect (GTK_OBJECT (althea_options), "activate",
                      GTK_SIGNAL_FUNC (on_options_menu_activate),
                      NULL);
  
  gtk_signal_connect (GTK_OBJECT (althea_exit), "activate",
                      GTK_SIGNAL_FUNC (on_exit_menu_activate),
                      NULL);
  /* 
  gtk_signal_connect (GTK_OBJECT (edit_menu), "activate",
                      GTK_SIGNAL_FUNC (on_edit_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (edit_copy), "activate",
                      GTK_SIGNAL_FUNC (on_copy_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (edit_cut), "activate",
                      GTK_SIGNAL_FUNC (on_cut_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (edit_paste), "activate",
                      GTK_SIGNAL_FUNC (on_paste_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (edit_clear), "activate",
                      GTK_SIGNAL_FUNC (on_clear_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (edit_select_all), "activate",
                      GTK_SIGNAL_FUNC (on_select_all_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_menu), "activate",
                      GTK_SIGNAL_FUNC (on_search_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_message), "activate",
                      GTK_SIGNAL_FUNC (on_search_in_message_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_folders), "activate",
                      GTK_SIGNAL_FUNC (on_search_in_folders_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_again), "activate",
                      GTK_SIGNAL_FUNC (on_search_again_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (search_advanced), "activate",
                      GTK_SIGNAL_FUNC (on_advanced_search_menu_activate),
                      NULL);
  */
  gtk_signal_connect (GTK_OBJECT (message_menu), "activate",
                      GTK_SIGNAL_FUNC (on_message_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (message_new), "activate",
                      GTK_SIGNAL_FUNC (on_new_message_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (message_save), "activate",
                      GTK_SIGNAL_FUNC (on_save_message_menu_activate),
                      NULL );
  gtk_signal_connect (GTK_OBJECT (message_reply_all), "activate",
                      GTK_SIGNAL_FUNC (on_reply_all_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (message_reply), "activate",
                      GTK_SIGNAL_FUNC (on_reply_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (message_forward), "activate",
                      GTK_SIGNAL_FUNC (on_forward_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (forward_message), "clicked",
                      GTK_SIGNAL_FUNC (on_forward_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (message_delete), "activate",
                      GTK_SIGNAL_FUNC (on_delete_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (message_undelete), "activate",
                      GTK_SIGNAL_FUNC (on_undelete_menu_activate),
                      NULL);
  /*
  gtk_signal_connect (GTK_OBJECT (message_move_to_folder), "activate",
                      GTK_SIGNAL_FUNC (on_move_to_folder_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (address_book_menu), "activate",
                      GTK_SIGNAL_FUNC (on_address_book_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (address_book_view), "activate",
                      GTK_SIGNAL_FUNC (on_view_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (address_book_add), "activate",
                      GTK_SIGNAL_FUNC (on_add_an_address_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (address_book_import), "activate",
                      GTK_SIGNAL_FUNC (on_import_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (address_book_export), "activate",
                      GTK_SIGNAL_FUNC (on_export_menu_activate),
                      NULL);
  */
  gtk_signal_connect (GTK_OBJECT (help_menu), "activate",
                      GTK_SIGNAL_FUNC (on_help_menu_activate),
                      NULL);
  /*
  gtk_signal_connect (GTK_OBJECT (help_index), "activate",
                      GTK_SIGNAL_FUNC (on_index_menu_activate),
                      NULL);
  */
  gtk_signal_connect (GTK_OBJECT (help_contents), "activate",
                      GTK_SIGNAL_FUNC (on_contents_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (help_about), "activate",
                      GTK_SIGNAL_FUNC (on_about_menu_activate),
                      NULL);
  gtk_signal_connect (GTK_OBJECT (folder_list), "tree_select_row",
                      GTK_SIGNAL_FUNC (on_folder_list_select_row),
                      NULL);




  // Add main_window to gAlthea
  gAlthea.set_main_window( main_window );

  //  Added the loading of the XML file here because we are doing it next anyway, and we need the accels
  load_Althea();

  // ADD ACCEL KEYS FOR MENU ITEMS
  menu_accel_group = gtk_accel_group_new();

  // C: check for new mail
  if (gAlthea.get_config()->get_key_accelerator(CHECK_MAIL)) {
  	gtk_widget_add_accelerator(althea_check_mail, "activate", menu_accel_group,
			     gAlthea.get_config()->get_key_accelerator(CHECK_MAIL), 0, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(althea_check_mail, "activate", menu_accel_group,
			     GDK_c, 0, GTK_ACCEL_VISIBLE);
  }
  // D: delete message
  if (gAlthea.get_config()->get_key_accelerator(DELETE_MESSAGE)) {
  	gtk_widget_add_accelerator(message_delete, "activate", menu_accel_group,
			     gAlthea.get_config()->get_key_accelerator(DELETE_MESSAGE), 0, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(message_delete, "activate", menu_accel_group,
			     GDK_d, 0, GTK_ACCEL_VISIBLE);
  }
  // F: forward message
  if (gAlthea.get_config()->get_key_accelerator(FORWARD_MESSAGE)) {
  	gtk_widget_add_accelerator(message_forward, "activate", menu_accel_group,
			     gAlthea.get_config()->get_key_accelerator(FORWARD_MESSAGE), 0, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(message_forward, "activate", menu_accel_group,
			     GDK_f, 0, GTK_ACCEL_VISIBLE);
  }
  // M: compose new message
  if (gAlthea.get_config()->get_key_accelerator(COMPOSE_MESSAGE)) {
  	gtk_widget_add_accelerator(message_new, "activate", menu_accel_group,
			     gAlthea.get_config()->get_key_accelerator(COMPOSE_MESSAGE), 0, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(message_new, "activate", menu_accel_group,
			     GDK_m, 0, GTK_ACCEL_VISIBLE);
  }
  // P: print message
  if (gAlthea.get_config()->get_key_accelerator(PRINT_MESSAGE)) {
  	gtk_widget_add_accelerator(message_print, "activate", menu_accel_group,
			     gAlthea.get_config()->get_key_accelerator(PRINT_MESSAGE), 0, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(message_print, "activate", menu_accel_group,
			     GDK_p, 0, GTK_ACCEL_VISIBLE);
  }
  // Q: quit Althea
  if (gAlthea.get_config()->get_key_accelerator(QUIT_ALTHEA)) {
  	gtk_widget_add_accelerator(althea_exit, "activate", menu_accel_group,
			     gAlthea.get_config()->get_key_accelerator(QUIT_ALTHEA), 0, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(althea_exit, "activate", menu_accel_group,
			     GDK_q, 0, GTK_ACCEL_VISIBLE);
  }
  // R: reply to message
  if (gAlthea.get_config()->get_key_accelerator(REPLY_MESSAGE)) {
  	gtk_widget_add_accelerator(message_reply, "activate", menu_accel_group,
			     gAlthea.get_config()->get_key_accelerator(REPLY_MESSAGE), 0, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(message_reply, "activate", menu_accel_group,
			     GDK_r, 0, GTK_ACCEL_VISIBLE);
  }
  // S: save message
  if (gAlthea.get_config()->get_key_accelerator(SAVE_MESSAGE)) {
  	gtk_widget_add_accelerator(message_save, "activate", menu_accel_group,
			     gAlthea.get_config()->get_key_accelerator(SAVE_MESSAGE), 0, GTK_ACCEL_VISIBLE);
  }
  else {
  	gtk_widget_add_accelerator(message_save, "activate", menu_accel_group,
			     GDK_s, 0, GTK_ACCEL_VISIBLE);
  }
  gtk_window_add_accel_group (GTK_WINDOW (main_window), menu_accel_group);


  ////////////////////////////////////////////////////////
  //  Ethan is trying to get drag and drop to work
  //
  //  taken and modified from balsa 1.1.7 (www.balsa.net)

  gtk_drag_source_set(GTK_WIDGET (message_list), 
		      GDK_BUTTON1_MASK,
		      index_drag_types, ELEMENTS(index_drag_types),
		      GDK_ACTION_MOVE);
  gtk_signal_connect(GTK_OBJECT(message_list), "drag-data-get",
		     GTK_SIGNAL_FUNC(on_althea_index_drag), NULL);
  


  gtk_drag_dest_set (GTK_WIDGET (folder_list), GTK_DEST_DEFAULT_ALL,
		     folder_list_drop_types,
		     ELEMENTS(folder_list_drop_types),
		     GDK_ACTION_MOVE );
  gtk_signal_connect (GTK_OBJECT (folder_list),"drag-data-received",
		      GTK_SIGNAL_FUNC (on_folder_list_drag), NULL);
  gtk_signal_connect (GTK_OBJECT (folder_list), "drag-motion", 
		      GTK_SIGNAL_FUNC (on_folder_list_drag_motion), 
		      (gpointer) NULL);




  return main_window;
}

