/*
 * Copyright (c) 1995 - 2000 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>

#include <err.h>
#include <roken.h>

#ifdef RCSID
RCSID("$Id: strange-characters-c.c,v 1.2 2000/10/03 00:35:54 lha Exp $");
#endif

static void
creat_file (char *name)
{
    int fd;

    fd = open (name, O_WRONLY | O_CREAT | O_EXCL, 0777);
    if (fd < 0)
	err (1, "open %s", name);
    if (close (fd) < 0)
	err (1, "close %s", name);
}

static void
look_at_file (char *name)
{
    int fd;

    fd = open (name, O_RDONLY | O_EXCL, 0777);
    if (fd < 0)
	err (1, "open %s", name);
    if (close (fd) < 0)
	err (1, "close %s", name);
}

static void
usage (int ret)
{
    fprintf (stderr, "%s\n", __progname);
    exit (ret);
}

int
main(int argc, char **argv)
{
    char *file = "";

    set_progname (argv[0]);

    if (argc != 1)
	usage (1);

    creat_file (file);
    look_at_file (file);
    return 0;
}
