/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * $Id: DdtMD.h,v 1.1 2001/11/24 21:26:16 benoit Exp $
 *
 * Copyright (c) 2001 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef DDTMD_H
#define DDTMD_H


#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

extern "C"
{
#include <stddef.h>
#include <gcrypt.h>
}

#include "Logger.h"

class DdtMD
{
public:
    enum MDAlgos
    {
        MD_NONE = GCRY_MD_NONE,
        MD_MD5 = GCRY_MD_MD5,
        MD_SHA1 = GCRY_MD_SHA1,
        MD_RMD160 = GCRY_MD_RMD160,
        MD_TIGER = GCRY_MD_TIGER
    };

    DdtMD(MDAlgos algo);
    ~DdtMD();

    void write(unsigned char *buf, int length);
    int doFinal(unsigned char *buf, int length);

    static int getAlgoDigestLength(MDAlgos algo);
    static int digest(MDAlgos algo, unsigned char* buf, int bufLength, unsigned char * digest, int digestLength);

private:
    GCRY_MD_HD mdHandle;
    MDAlgos algo;
};


#endif
