/* Update Query and Reply */
enum DDTPv1UpdateQueryOpCode
{
    MARK_ONLINE,
    MARK_OFFLINE
};

struct DDTPv1UpdateQuery
{
    DDTPv1UpdateQueryOpCode opCode;
    unsigned long           ipAddress;
    opaque                  updatePassword[9];
};

enum DDTPv1UpdateReplyStatus
{
    UPDATE_SUCCEEDED,
    UPDATE_FAILED,
    INVALID_PASSWORD,
    INVALID_ACCOUNT,
    INVALID_OPCODE
};

struct DDTPv1UpdateReply
{
    DDTPv1UpdateReplyStatus status;
};

/* Alive Query and Reply */
struct DDTPv1AliveQuery
{
    int dummy;
};

struct DDTPv1AliveReply
{
    int dummy;
};

/****** ******/
enum DDTPv1MessageType
{
    MESSAGE_ERROR,
    UPDATE_QUERY,
    UPDATE_REPLY,
    ALIVE_QUERY,
    ALIVE_REPLY
};

enum DDTPv1MessageStatus
{
    INVALID_MESSAGE_TYPE
};

union DDTPv1Message switch (DDTPv1MessageType messageType)
{
    case UPDATE_QUERY:
        DDTPv1UpdateQuery   updateQuery;
    case UPDATE_REPLY:
        DDTPv1UpdateReply   updateReply;
    case ALIVE_QUERY:
        DDTPv1AliveQuery    aliveQuery;
    case ALIVE_REPLY:
        DDTPv1AliveReply    aliveReply;
    default:
        DDTPv1MessageStatus status;
};

/****** ******/
struct DDTPv1Plaintext
{
    int             accountId;
    DDTPv1Message   msg;
};

struct DDTPv1Blowfish
{
    int             accountId;      /* DDT user account ID                  */
    opaque          msg[64];        /* blowfish encrypted DDTPv1Message     */
                                    /* ensure that this is big enough to    */
                                    /* hold the entire encrypted message    */
    opaque          iv[8];          /* blowfish cbc initialization vector   */
    opaque          check[8];       /* the iv encrypted -- encryption check */
};

/****** ******/
enum EncryptionType
{
    ENCRYPTION_ERROR,
    PLAINTEXT,
    BLOWFISH
};

enum DDTPv1PacketStatus
{
    INVALID_ENCRYPTION_TYPE,
    ACCOUNT_INVALID,
    PASSWORD_INVALID,
    XDR_DECODE_FAILURE
};

union DDTPv1Packet switch (EncryptionType encryptionType)
{
    case PLAINTEXT:
        DDTPv1Plaintext     pt;
    case BLOWFISH:
        DDTPv1Blowfish      bf;
    default:
        DDTPv1PacketStatus  status;
};

/****** ******/
enum ProtocolVersion
{
    PROTOCOL_ERROR,
    DDTPv1,
    DDTPv2
};

enum DdtpPacketStatus
{
    INVALID_PROTOCOL
};

union DdtpPacket switch (ProtocolVersion protocolVersion)
{
    case DDTPv1:
        DDTPv1Packet ddtpv1;
    /* case DDTPv2:                 */
    /*     DDTPv2Packet ddtpv2;     */
    default:
        DdtpPacketStatus status;
};

