/********************************

 Simple config file class.     

 Author: Ulrich Clanget
 Copying: Freeware

********************************/

/* CConfigGroup.h */

#ifndef CCONFIGGROUP_H
#define CCONFIGGROUP_H

// qt include
#include <qstring.h>
#include <qmap.h>
#include <qfont.h>
#include <qapplication.h> 

// group map type
typedef QMap<QString, QString> GroupMap;


class CConfigGroup
{
  friend class CConfigFile;

 public:

  CConfigGroup(const QString& groupname);
  CConfigGroup();

  void setName(const QString& groupname);
  const QString& name() const { return groupname; }

  const QString& readEntry(const QString& key, const QString& default_value = QString::null);
  QFont readFontEntry( const QString& key,  const QFont* pDefault );

  void writeEntry(const QString& key, const QString& value);
  void writeFontEntry( const QString& key, const QFont& rFont );
  bool isEmpty() const { return map.isEmpty(); }
 private:

  QString groupname;
  GroupMap map;
};

#endif


/***************************************************************************
                          CConfigGroup.h  -  description
                             -------------------
    begin                : Tue Jul 25 2000
    copyright            : (C) 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

