#include "imgstore.h"
#ifndef __imageh__
  #include "image.h"
#endif

map<string,IMGStore::Image> IMGStore::m_imgMap;

bool IMGStore::GetSize(const string& fname,int& width,int& height){
  map<string,Image>::iterator iter=m_imgMap.find(fname);
  if(iter!=m_imgMap.end()){
    width=(*iter).second.m_width;
    height=(*iter).second.m_height;
    return (*iter).second.m_OK;
  }else{
    IMAGEFILE img;
    bool success(false);
    if(OpenImage(fname.c_str(),&img)){
      if(GetImageDimensions(&img,width,height)) success=true;
      CloseImage(&img);
    }
    m_imgMap[fname]=Image(width,height,success);
    return success;
  }
}
