#ifndef __htmlstreamh__
  #include "../htmlstream.h"
#endif

#ifndef __htmlh__
  #include "../html.h"
#endif

#ifndef __stringproch__
  #include "../stringproc.h"
#endif

#ifndef __pluginh__
  #include "../plugin.h"
#endif

#include <string>
#include <vector>
#include <cstdio>

class dsoFrancaisMod :public Plugin{
public:
  dsoFrancaisMod();
  virtual void Init();
private:
  static void DAYNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYSHORTNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHSHORTNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYABBREV(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHABBREV(const HTML& Cur,string& data,const vector<string>& params);
};

static dsoFrancaisMod initmodule;

static const string daynames[]={"dimanche","lundi","mardi","mecredi","jeudi",
  "vendredi","samedi"};
static const string monthnames[]={"janvier","f&eacute;vrier","mars","avril",
  "mai","juin","juillet","ao&ucircum;t","septembre","octobre","novembre",
  "d&eacute;cembre"};
static const string dayshortnames[]={"dim","lun","mar","mec","jeu","ven",
  "sam"};
static const string monthshortnames[]={"jan","f&eacute;v","mar","avr",
  "mai","jun","jui","ao&ucircum;","sep","oct","nov","d&eacute;c"};
static const string dayabbrevs[]={"d","d","ma","me","j","v","s"};
static const string monthabbrevs[]={"jan","f&eacute;v","mar","avr",
  "mai","jun","jui","ao&ucircum;","sep","oct","nov","d&eacute;c"};

dsoFrancaisMod::dsoFrancaisMod() {
  RegisterPlugin(string("francais"),1);
}

void dsoFrancaisMod::Init(){
  SetNamespace("FRANCAIS");
  RegisterFunction("DAYNAME",&DAYNAME);
  RegisterFunction("MONTHNAME",&MONTHNAME);
  RegisterFunction("DAYSHORTNAME",&DAYSHORTNAME);
  RegisterFunction("MONTHSHORTNAME",&MONTHSHORTNAME);
  RegisterFunction("DAYABBREV",&DAYABBREV);
  RegisterFunction("MONTHABBREV",&MONTHABBREV);
}

void dsoFrancaisMod::DAYNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYNAME",e_ParamNone);
  data=daynames[atoi(data.c_str())%7];
}

void dsoFrancaisMod::MONTHNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"MONTHNAME",e_ParamNone);
  data=monthnames[(atoi(data.c_str())-1)%12];
}

void dsoFrancaisMod::DAYSHORTNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYSHORTNAME",e_ParamNone);
  data=dayshortnames[atoi(data.c_str())%7];
}

void dsoFrancaisMod::MONTHSHORTNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYABBREV",e_ParamNone);
  data=monthshortnames[(atoi(data.c_str())-1)%12];
}

void dsoFrancaisMod::DAYABBREV(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=dayabbrevs[atoi(data.c_str())%7];
}

void dsoFrancaisMod::MONTHABBREV(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=monthabbrevs[(atoi(data.c_str())-1)%12];
}
