#include "stringproc.h"
#ifndef __dtutilsh__
  #include "dtutils.h"
#endif
#ifndef __errorh__
  #include "error.h"
#endif
#ifndef __hitopcoreh__
  #include "hitopcore.h"
#endif
#ifndef __mathsh__
  #include "maths.h"
#endif
#ifndef __tables_entitiesh__
  #include "tables/entities.h"
#endif
#include <algorithm>
#include <stdio.h>
#include <cctype>
#include <unistd.h>

bool StringProc::actionMapInitialized=false;
map<string,StringProc::actionFunction> StringProc::actionMap;

void StringProc::REPEAT(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=1) Error(Cur,"REPEAT",e_ParamOne);
  int c=atoi(params[0].c_str());
  if (c==0) {
    data.erase();
    return;
  }
  string what = data;
  while (--c>0) data.append(what);
}

void StringProc::LENGTH(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"LENGTH",e_ParamNone);
  data=IToS(data.length());
}

void StringProc::FREQ(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=1) Error(Cur,"FREQ",e_ParamOne);
  if (params[0].length()==0) {
    data=IToS(data.length());
  } else {
    int i=-1;
    string::iterator j=data.begin();
    while (j!=data.end()) {
      j=search(j,data.end(),params[0].begin(),params[0].end());
      ++i;
      if (j!=data.end()) ++j;
    }
    if (i==-1) i=0;
    data=IToS(i);
  }
}

void StringProc::REPLACE(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()>2) Error(Cur,"REPLACE",e_ParamWrong);
  if(params.size()==2){
    global_replace(data,params[0],params[1]);
  }else{
    global_replace(data,params[0],"");
  }
}

void StringProc::UPCASE(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"UPCASE",e_ParamNone);
  transform(data.begin(),data.end(),data.begin(),toupper);
}

void StringProc::DOWNCASE(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"DOWNCASE",e_ParamNone);
  transform(data.begin(),data.end(),data.begin(),tolower);
}

class StringProc::notin {
public:
  notin (const string& list):m_list(list) {};
  bool operator()(char what) {return (m_list.end()==find(m_list.begin(),m_list.end(),what)); }
private:
  const string& m_list;
};

void StringProc::REMOVENOTOF(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=1) Error(cur,"REMOVENOTOF",e_ParamOne);
  data.erase(remove_if(data.begin(),data.end(),notin(params[0])),data.end());
}

void StringProc::ESCAPECHARS(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"ESCAPECHARS",e_ParamNone);
  data=Entities::Escape(data);
}

void StringProc::UNESCAPECHARS(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"UNESCAPECHARS",e_ParamNone);
  data=Entities::Unescape(data);
}

void StringProc::ESCAPEURL(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"ESCAPEURL",e_ParamNone);
  data=escape(data);
}

void StringProc::UNESCAPEURL(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"UNESCAPEURL",e_ParamNone);
  data = unescape(data);
}

void StringProc::EVAL(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"EVAL",e_ParamNone);
  data=evaluate(data);
}

void StringProc::RANDOM(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"RANDOM",e_ParamNone);
  int range=atoi(data.c_str());
  if(range==0){
    data="0";
  }else{
    data=IToS(rand()%range);
  }
}

void StringProc::MID(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=2) Error(Cur,"MID",e_ParamWrong);
  int from=atoi(params[0].c_str());
  int len=atoi(params[1].c_str());
  if (from<0) from+=data.length();
  if (len<0) len+=data.length();
  if (from<0) {
    len+=from;
    from=0;
  } else if (from>static_cast<int>(data.length())) {
    data.erase();
    return;
  }
  if ((from+len)>static_cast<int>(data.length())) {
    len=data.length()-from;
  }
  if (len<0) len=0;
  data=data.substr(from,len);
}

void StringProc::LEFT(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=1) Error(Cur,"LEFT",e_ParamOne);
  int num=atoi(params[0].c_str());
  if(num<0) num+=data.length();
  if(num<0) {
    num=0;
  } else if (num>static_cast<int>(data.length())) {
    num=data.length();
  }
  data=data.substr(0,num);
}

void StringProc::RIGHT(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=1) Error(Cur,"RIGHT",e_ParamOne);
  int num=atoi(params[0].c_str());
  if (num>0) {
    num=data.length()-num;
  } else {
    num=-num;
  }
  if(num<0) {
    num=0;
  } else if (num>static_cast<int>(data.length())) {
    data.erase();
    return;
  }
  data=data.substr(num,data.length()-num);
}

void StringProc::PADLEFT(const HTML& Cur,string& data,const vector<string>& params){
  string pad=" ";
  if(params.size()==1){
  }else if ((params.size()==2)&&(!params[1].empty())){
    pad=params[1];
  }else{
    Error(Cur,"PADLEFT",e_ParamWrong);
  }
  int size=atoi(params[0].c_str());
  while(int(data.length())<size){
    data=pad+data;
  }
}

void StringProc::PADRIGHT(const HTML& Cur,string& data,const vector<string>& params){
  string pad=" ";
  if(params.size()==1){
  }else if((params.size()==2)&&(!params[1].empty())){
    pad=params[1];
  }else{
    Error(Cur,"PADRIGHT",e_ParamWrong);
  }
  int size=atoi(params[0].c_str());
  while(int(data.length())<size){
    data+=pad;
  }
}

void StringProc::BEFORE(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=1) Error(Cur,"BEFORE",e_ParamOne);
  string::iterator found=search(data.begin(),data.end(),params[0].begin(),params[0].end());
  if(found==data.end()){
    data.erase();
    return;
  }
  data=string(data.begin(),found);
}

void StringProc::AFTER(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=1) Error(Cur,"AFTER",e_ParamOne);
  string::iterator found=search(data.begin(),data.end(),params[0].begin(),params[0].end());
  if(found==data.end()){
    data.erase();
    return;
  }
  data=string(found+params[0].length(),data.end());
}

void StringProc::REVERSE(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"REVERSE",e_ParamNone);
  reverse(data.begin(),data.end());
}

static int global_count(const string& st,const string& find){
  int len=find.length(),count=0;
  string::const_iterator pos,first=st.begin(),last=st.end();
  do{
    pos=search(first,last,find.begin(),find.end());
    if(pos==last) break;
    ++count;
    first=pos+len;
  }while(pos!=last);
  return count;
}

void StringProc::WORDS(const HTML& Cur,string& data,const vector<string>& params){
  int count=params.size();
  string sep;
  if(count==0){
    sep=" ";
  }else if(count==1){
    sep=params[0];
  }else{
    Error(Cur,"WORDS",e_ParamWrong);    
  }
  if(data.empty()){
    data="0";
    return;
  }
  int freq=global_count(data,sep)+1;
  data=IToS(freq);
}

void StringProc::WORDSPAN(const HTML& Cur,string& data,const vector<string>& params){
  int count=params.size();
  string sep;
  if(count==2){
    sep=" ";
  }else if(count==3){
    sep=params[2];
  }else{
    Error(Cur,"WORDSPAN",e_ParamWrong);    
  }
  int length=global_count(data,sep)+1;
  int start=atoi(params[0].c_str())-1;
  int end=atoi(params[1].c_str())-1;
  if(start<0) start+=length+1;
  if(end<0) end+=length;
  if(start<0) {
    end+=start;
    start=0;
  }
  ++end;
  if(end<0) end=0;
  string::iterator istart=data.begin(),iend;
  for (;start!=0;--start) {
    istart=search(istart,data.end(),sep.begin(),sep.end());
    if (istart!=data.end()) istart+=sep.length();
  }
  iend=istart;
  for (;end!=0;--end) {
    iend=search(iend,data.end(),sep.begin(),sep.end());
    if (iend!=data.end()) iend+=sep.length();
  }
  if ((iend!=data.end())&&(istart!=iend)) iend-=sep.length();
  data=string(istart,iend);
}

void StringProc::WORD(const HTML& Cur,string& data,const vector<string>& params){
  int pos,count=params.size();
  string sep;
  if(count==1){
    sep=" ";
  }else if(count==2){
    sep=params[1];
  }else{
    Error(Cur,"WORD",e_ParamWrong);
  }
  pos=atoi(params[0].c_str())-1;
  if (pos<0) {
    pos+=global_count(data,sep) +2;
  }
  if (pos <0) {
    data.erase();
    return;
  }
  string::iterator start=data.begin(),end;
  for (;pos>0;--pos) {
    start=search(start,data.end(),sep.begin(),sep.end());
    if (start!=data.end()) start+=sep.length();
  }
  end=search(start,data.end(),sep.begin(),sep.end());
  data=string(start,end);
}

static time_t ISOToDate(const string& st){
  tm temp={0,0,0,0,0,0,0,0,0};
  sscanf(st.c_str(),"%d-%d-%d",&temp.tm_year,&temp.tm_mon,&temp.tm_mday);
  temp.tm_year-=1900;
  temp.tm_mon--;
  return mktime(&temp);
}

void StringProc::DATETODAYNUM(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"DATETODAYNUM",e_ParamNone);
  time_t secs=ISOToDate(data);
  secs=(secs+12*60*60)/(24*60*60)+719162;
  data=IToS(secs);
}

void StringProc::DAYNUMTODATE(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"DAYNUMTODATE",e_ParamNone);
  time_t secs=(atoi(data.c_str())-719162)*(24*60*60)+(12*60*60);
  tm* time=localtime(&secs);
  char temp[11];
  strftime(temp,11,"%Y-%m-%d",time);
  data=temp;
}

void StringProc::DAYOFWEEK(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"DAYOFWEEK",e_ParamNone);
  time_t secs=ISOToDate(data);
  secs=((secs+12*60*60)/(24*60*60)+719162)%7+1;
  data=IToS(secs);
}

void StringProc::C2X(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"C2X",e_ParamNone);
  string temp;
  char chx[4];
  for(string::iterator i=data.begin();i!=data.end();++i){
    sprintf(chx,"%02X",*i);
    temp+=chx;
  }
  data=temp;
}

void StringProc::D2X(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"D2X",e_ParamNone);
  char ch[20];
  sprintf(ch,"%X",atoi(data.c_str()));
  data=ch;
}

void StringProc::ROMAN(const HTML& Cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(Cur,"ROMAN",e_ParamNone);
  int num=atoi(data.c_str());
  data.erase();
  if((num<0)||(num>5999)){
    data="["+IToS(num)+"]";
  }else{
    while(num>=1000){num-=1000; data+="m";}
    while(num>=900){num-=900; data+="cm";}
    while(num>=500){num-=500; data+="d";}
    while(num>=400){num-=400; data+="cd";}
    while(num>=100){num-=100; data+="c";}
    while(num>=90){num-=90; data+="xc";}
    while(num>=50){num-=50; data+="l";}
    while(num>=40){num-=40; data+="xl";}
    while(num>=10){num-=10; data+="x";}
    while(num>=9){num-=9; data+="ix";}
    while(num>=5){num-=5; data+="v";}
    while(num>=4){num-=4; data+="iv";}
    while(num>=1){num-=1; data+="i";}
  }
}

void StringProc::RegisterFunction(const string& name,actionFunction procedure){
  if (!actionMapInitialized) InitializeActionMap();
  actionMap[name]=procedure;
}

void StringProc::UnregisterFunction(const string& name,actionFunction procedure){
  map<string,actionFunction>::iterator entry= actionMap.find(name);
  if ((entry!=actionMap.end())&&(entry->second==procedure)) actionMap.erase(name);
}

void StringProc::InitializeActionMap(){
  srand(time(NULL)+getpid());

  // Date handling
  actionMap["DATETODAYNUM"]=DATETODAYNUM;// ()
  actionMap["DAYNUMTODATE"]=DAYNUMTODATE;// ()
  actionMap["DAYOFWEEK"]=DAYOFWEEK;      // ()

  // String manipulation
  actionMap["UPCASE"]=UPCASE;            // ()
  actionMap["DOWNCASE"]=DOWNCASE;        // ()
  actionMap["ESCAPEURL"]=ESCAPEURL;      // ()
  actionMap["UNESCAPEURL"]=UNESCAPEURL;  // ()
  actionMap["ESCAPECHARS"]=ESCAPECHARS;  // ()
  actionMap["UNESCAPECHARS"]=UNESCAPECHARS;// ()
  actionMap["REMOVENOTOF"]=REMOVENOTOF;  // (s)
  actionMap["REVERSE"]=REVERSE;          // ()
  actionMap["REPLACE"]=REPLACE;          // (s,s)
  actionMap["REPEAT"]=REPEAT;            // (n)
  actionMap["PADLEFT"]=PADLEFT;          // (n) (n,s)
  actionMap["PADRIGHT"]=PADRIGHT;        // (n) (n,s)

  // String extraction
  actionMap["BEFORE"]=BEFORE;            // (s)
  actionMap["AFTER"]=AFTER;              // (s)
  actionMap["LEFT"]=LEFT;                // (n)
  actionMap["RIGHT"]=RIGHT;              // (n)
  actionMap["MID"]=MID;                  // (n,n)

  // Enquiry
  actionMap["LENGTH"]=LENGTH;            // ()
  actionMap["FREQ"]=FREQ;                // (s)

  // Word extraction
  actionMap["WORD"]=WORD;                // (n) (n,s)
  actionMap["WORDS"]=WORDS;              // () (s)
  actionMap["WORDSPAN"]=WORDSPAN;        // (n,n) (n,n,s)

  // Maths & Number
  actionMap["EVAL"]=EVAL;                // ()
  actionMap["RANDOM"]=RANDOM;            // ()

  // Format Conversion
  actionMap["C2X"]=C2X;                  // ()
  actionMap["D2X"]=D2X;                  // ()
  actionMap["ROMAN"]=ROMAN;              // ()

  actionMapInitialized=true;
}

void StringProc::ProcessString(const HTML& Cur,string& data,const string& inst){
  if(!actionMapInitialized) InitializeActionMap();
  enum State {Outside,InBrackets,ExpectColon,InsideQuote,InsideDouble};
  State curState=Outside;
  bool beenQuoted=false;
  string curThing,procName;
  vector<string> param;
  for(string::const_iterator i=inst.begin();i!=inst.end();++i){
    const char& ch(*i);
    if(curState==Outside){
      if(ch=='('){
        procName=curThing;
        curThing.erase();
        curState=InBrackets;
      }else{
        curThing+=ch;
      }
    }else if(curState==InBrackets){
      if((ch==')')||(ch==',')){
        if((!curThing.empty())||beenQuoted) param.push_back(curThing);
        curThing.erase();
        if(ch==')'){
          if(!g_isXML) transform(procName.begin(),procName.end(),procName.begin(),toupper);
          map<string,StringProc::actionFunction>::iterator funcPoint=actionMap.find(procName);
          if(funcPoint==actionMap.end()) Error(Cur,e_UndefStringProc,procName);
          (*(funcPoint->second))(Cur,data,param);
          param.clear();
          curState=ExpectColon;
          beenQuoted=false;
        }
      }else if(ch=='\''){
        curState=InsideQuote;
        beenQuoted=true;
      }else if(ch=='"'){
        curState=InsideDouble;
        beenQuoted=true;
      }else{      
        curThing+=ch;
      }
    }else if(curState==ExpectColon){
      if(ch!=':') Error(Cur,e_MissingColon);
      curState=Outside;
    }else if(curState==InsideQuote){
      if(ch=='\'') curState=InBrackets; else curThing+=ch;
    }else if(curState==InsideDouble){
      if(ch=='"') curState=InBrackets; else curThing+=ch;
    }
  }
  if(curState==Outside){
    Error(Cur,e_ExpectBrackets);
  }else if(curState==InBrackets){
    Error(Cur,e_ExpectCloseBracket);
  }else if((curState==InsideQuote)||(curState==InsideDouble)){
    Error(Cur,e_UntermQuotes);
  }
}
