// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#include "controls.h"
#include "output.h"
#include "icons.h"

#include <qlayout.h>
#include <qtoolbutton.h>
#include <qtooltip.h>
#include <qsettings.h>
#include <qlabel.h>


Controls::Controls(QWidget *parent, const char *name)
    : QFrame(parent, name)
{
    setFrameStyle(NoFrame);

    // first row...
    // organizer
    organizer = new QToolButton(this);
    organizer->setText(tr("Organizer"));
    organizer->setAutoRaise(TRUE);
    organizer->setSizePolicy( QSizePolicy( QSizePolicy::Minimum,
					   QSizePolicy::Fixed ) );
    QToolTip::add(organizer, tr("Media Organizer"));
    connect(organizer, SIGNAL(clicked()), SIGNAL(Organizer()));

    // equalizer
    equalizer = new QToolButton(this);
    equalizer->setText(tr("Equalizer"));
    equalizer->setAutoRaise(TRUE);
    equalizer->setSizePolicy( QSizePolicy( QSizePolicy::Minimum,
					   QSizePolicy::Fixed ) );
    QToolTip::add(equalizer, tr("Equalizer"));
    connect(equalizer, SIGNAL(clicked()), SIGNAL(Equalizer()));

    // configuration
    configuration = new QToolButton(this);
    configuration->setText(tr("Options"));
    configuration->setAutoRaise(TRUE);
    configuration->setSizePolicy( QSizePolicy( QSizePolicy::Minimum,
					       QSizePolicy::Fixed ) );
    QToolTip::add(configuration, tr("Configuration Options"));
    connect(configuration, SIGNAL(clicked()), SIGNAL(Configuration()));

    QHBoxLayout *hbox1 = new QHBoxLayout(2);
    hbox1->addWidget(organizer);
    hbox1->addWidget(equalizer);
    hbox1->addWidget(configuration);

    // second row...
    // play button
    play = new QToolButton(this);
    play->setAutoRaise(TRUE);
    play->setSizePolicy( QSizePolicy( QSizePolicy::Minimum,
				      QSizePolicy::Fixed ) );
    connect(play, SIGNAL(clicked()), SIGNAL(Play()));

    // ugly hack... try to get a feel for the size of the icon theme by loading the
    // play icon and applying it
    QPixmap p = IconLoader::load("play").pixmap(QIconSet::Small, QIconSet::Normal);
    p.fill(backgroundColor());
    play->setIconSet(p);

    // pause button
    pause = new QToolButton(this);
    pause->setAutoRaise(TRUE);
    pause->setSizePolicy( QSizePolicy( QSizePolicy::Minimum,
				       QSizePolicy::Fixed ) );
    connect(pause, SIGNAL(clicked()), SIGNAL(Pause()));

    // next
    next = new QToolButton(this);
    next->setAutoRaise(TRUE);
    next->setSizePolicy( QSizePolicy( QSizePolicy::Minimum,
				      QSizePolicy::Fixed ) );
    connect(next, SIGNAL(clicked()), SIGNAL(Next()));

    // previous
    prev = new QToolButton(this);
    prev->setAutoRaise(TRUE);
    prev->setSizePolicy( QSizePolicy( QSizePolicy::Minimum,
				      QSizePolicy::Fixed ) );
    connect(prev, SIGNAL(clicked()), SIGNAL(Previous()));

    // stop
    stop = new QToolButton(this);
    stop->setAutoRaise(TRUE);
    stop->setSizePolicy( QSizePolicy( QSizePolicy::Minimum,
				      QSizePolicy::Fixed ) );
    connect(stop, SIGNAL(clicked()), SIGNAL(Stop()));

    QHBoxLayout *hbox2 = new QHBoxLayout(2);
    hbox2->addWidget(prev);
    hbox2->addWidget(pause);
    hbox2->addWidget(play);
    hbox2->addWidget(stop);
    hbox2->addWidget(next);

    QVBoxLayout *vbox = new QVBoxLayout(this, 0, 2);
    vbox->addLayout(hbox1);
    vbox->addLayout(hbox2);

    setSizePolicy( QSizePolicy( QSizePolicy::Minimum,
				QSizePolicy::Fixed ) );
}


void Controls::configChanged(QSettings &settings)
{
    bool b = settings.readBoolEntry("/MQ3/useLargeIcons", false);
    prev->setUsesBigPixmap(b);
    pause->setUsesBigPixmap(b);
    play->setUsesBigPixmap(b);
    stop->setUsesBigPixmap(b);
    next->setUsesBigPixmap(b);
    organizer->setUsesBigPixmap(b);
    equalizer->setUsesBigPixmap(b);
    configuration->setUsesBigPixmap(b);

    QIconSet iconset = IconLoader::load("play");
    play->setIconSet(iconset);

    iconset = IconLoader::load("pause");
    pause->setIconSet(iconset);

    iconset = IconLoader::load("next");
    next->setIconSet(iconset);

    iconset = IconLoader::load("prev");
    prev->setIconSet(iconset);

    iconset = IconLoader::load("stop");
    stop->setIconSet(iconset);

    /*
      iconset = IconLoader::load("organizer");
      organizer->setIconSet(iconset);

      iconset = IconLoader::load("equalizer");
      equalizer->setIconSet(iconset);

      iconset = IconLoader::load("config");
      configuration->setIconSet(iconset);
    */
}

