// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef controls_h
#define controls_h

#include <qframe.h>


class QToolButton;
class QSettings;


class Controls : public QFrame
{
    Q_OBJECT

public:
    Controls(QWidget *parent = 0, const char *name = 0);

    void configChanged(QSettings &);


signals:
    void Play();
    void Stop();
    void Pause();
    void Previous();
    void Next();
    void Organizer();
    void Equalizer();
    void Configuration();


private:
    QToolButton *play, *next, *prev, *pause, *stop,
	*organizer, *equalizer, *configuration;
};


#endif // controls_h
