// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef EQPRESET_H
#define EQPRESET_H

#include <qstring.h>

class QDataStream;


class EqPreset
{
public:
    EqPreset();
    EqPreset(const EqPreset &preset);
    EqPreset(const QString &);
    EqPreset(const QString &, int[10], int);
    ~EqPreset();

    bool isDefault() const { return def; }

    const QString &name() const { return nm; }
    void setName(const QString &n) { nm = n; }

    int band(int b) const{ if (b < 0 || b > 9) return -1; else return bands[b]; }
    void setBand(int b, int v) { if (b < 0 || b > 9) return; else bands[b] = v; }

    int preamp() const { return pre; }
    void setPreamp(int p) { pre = p; }

    EqPreset &operator=( const EqPreset & );
    bool operator==( const EqPreset & ) const;
    bool operator!=( const EqPreset & ) const;


private:
    QString nm;
    bool def;
    int bands[10];
    int pre;

    friend class Equalizer;
    friend QDataStream &operator<<( QDataStream &, const EqPreset & );
    friend QDataStream &operator>>( QDataStream &, EqPreset & );
};

#endif // EQPRESET_H
