// Copyright (c) 2000-2001 Brad Hughes <bhughes@trolltech.com>
//
// Use, modification and distribution is allowed without limitation,
// warranty, or liability of any kind.
//

#ifndef SONG_H
#define SONG_H

#include <qlistview.h>
#include <qstring.h>
#include <qstringlist.h>

class Group;

class QDomElement;
class QTextStream;


class Song : public QCheckListItem
{
public:
    class Signature {
    public:
	Signature() { a = b = c = d = 0; }
	Signature(const QString &s) { fromString(s); }
	Signature(const Signature &s) { a = s.a; b = s.b; c = s.c; d = s.d; }

	unsigned int a;
	unsigned int b;
	unsigned int c;
	unsigned int d;

	QString toString() const
	{
	    QString s;
	    s.sprintf("%08x-%08x-%08x-%08x", a, b, c, d);
	    return s;
	}

	bool fromString(const QString &s)
	{
	    QStringList l = QStringList::split('-', s);
	    if (l.count() != 4)
		return false;

	    a = l[0].toUInt(0, 16);
	    b = l[1].toUInt(0, 16);
	    c = l[2].toUInt(0, 16);
	    d = l[3].toUInt(0, 16);

	    return isValid();
	}

	bool isValid()
	{
	    return ( a != 0 && b != 0 && c != 0 && d != 0 );
	}

	Signature &operator=(const Signature &s)
	{
	    a = s.a;
	    b = s.b;
	    c = s.c;
	    d = s.d;
	    return *this;
	}

	bool operator==(const Signature &s) const
	{
	    return ( a == s.a && b == s.b && c == s.c && d == s.d );
	}
    };

    Song(Group *, const QString &, const QString &, const QString &, int = 1);
    Song(Group *, const QString &, const QString &, const QString &,
	 const Signature &, int = 1);
    ~Song();

    void setup();

    void paintCell(QPainter *, const QColorGroup &, int, int, int);

    QString title() const;
    const QString &location() const { return loc; }
    const int &priority() const { return pri; }
    double length() const { return len; }
    const bool current() const { return curr; }
    const Signature &signature() const { return sig; }
    const QString &equalizer() const { return eq; }

    QString text(int) const;

    void setLocation(const QString &);
    void setText(int, const QString &);
    void setPriority(int);
    void setOn(bool);
    void setCurrent(bool);
    void setLength(double d) { len = d; }
    void setSignature(const Signature &s) { sig = s; }
    void setEqualizer(const QString &e);
    void xmlDescription(QTextStream &) const;

    static int RTTI;
    int rtti() const;

    static void create(Group *, const QDomElement &);


private:
    void calcSig();

    Group *group;
    QString coltext, loc, ttl, eq;
    int pri;
    double len;
    bool curr;
    Signature sig;
};

#endif // SONG_H
