/*
 * Ras server thread for OpenGate
 * 
 * Copyright (c) Egoboo Ltd. 1999-2000
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open Gatekeeper
 *
 * The Initial Developer of the Original Code is Egoboo Ltd.
 *
 * $Log: RasThread.h,v $
 * Revision 1.7  2000/05/12 14:00:59  aunitt
 * Renamed PRasLog to Log
 *
 * Revision 1.6  2000/04/27 17:42:48  aunitt
 * Added support for handling registration timeouts.
 *
 * Revision 1.5  2000/04/10 19:10:58  aunitt
 * Moved environment data into new environment object to tidy things up.
 *
 * Revision 1.4  2000/04/05 15:14:55  aunitt
 * Added PRasLog object.
 *
 * Revision 1.3  2000/03/12 21:17:59  aunitt
 * Fixed bug in not handling  messages from endpoints that were not registered
 *
 * Revision 1.2  2000/02/27 20:44:33  aunitt
 * Fixed problems with replying to wrong RAS address
 *
 * Revision 1.1.1.1  2000/02/01 22:25:34  aunitt
 * Initial revision
 *
 *
 */

#ifndef _RASTHREAD_H
#define _RASTHREAD_H

#include <ptlib.h>
#include <ptlib/sockets.h>
#include <h225.h>
#include "Environ.h"
#include "Defaults.h"
#include "EndpointTabl.h"
#include "CallTabl.h"
#include "RasServer.h"

class RasThread : public PThread, public RegistrationTimeoutHdlr
{
	PCLASSINFO(RasThread, PThread)
	public:
		RasThread( const Environ &  AkaEnviron,
                   const WORD       Port = GKDefaults::RASPort
                 );
		virtual ~RasThread();

		void Close();	

		virtual bool OnRegistrationTimeout( const H225_EndpointIdentifier & Id,
                                                  unsigned                  Chance,
                                                  PTimeInterval &           NextPeriod
                                          );
        // Task: To handle a registration timeout
		
	protected:
		RasThread();	                // Stop clients calling default cons
		RasThread( const RasThread & ); // ...or copy constructor

		virtual void Main();	

		BOOL ReadRasReq( H225_RasMessage &			Mesg,
						 H225_TransportAddress &	ReplyTo
					   );
		BOOL WriteRasReply( const H225_TransportAddress & ReplyTo,
		                          H225_RasMessage &       Mesg
		                  );
        BOOL SendIRR( const Endpoint & EP );
        // Task: to send an IRR to the given endpoint

        BOOL SendURQ( const Endpoint &                  EP,
                      const H225_UnregRequestReason &   Reason
                    );
        // Task: to send an URQ to the given endpoint		
	
		const Environ & MyEnviron;
		PUDPSocket      RASSocket;
		RasServer *     RasServ;
};

#endif // _RASTHREAD_H
