/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include "config.h"
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>

#ifdef GTK_FACE
#include "gui.h"
#include "gprop.h"
#include "gaccel.h"

struct rc_terms {
	char *name;
	enum {
		GKEY_MENUACCEL ,
		GKEY_PROP ,
		GKEY_LAST
	} id;
};

static struct rc_terms gkey_rc[] = {
	{"MenuAccel:", GKEY_MENUACCEL},
	{"Property:", GKEY_PROP}
};

void gkey_load()
{
	char pom[2048];
	FILE *f;
	char *line;
	int found = FALSE;
	int i;

	sprintf(pom, "%s/.pavuk_keys" , cfg.path_to_home);

	f = fopen(pom , "rb");

	if (!f) return;

	while((line = fgets(pom, sizeof(pom) , f)))
	{
		if (*line == '#') continue;
		if (!strcspn(line , " \t\r\n")) continue;

		found = FALSE;
		for (i = 0 ; i < GKEY_LAST ; i++)
		{
			if (!strncasecmp(gkey_rc[i].name, line , strlen(gkey_rc[i].name)))
			{
				found = TRUE;
				break;
			}
		}
		if (!found)
			fprintf(stderr, gettext("Unable to parse: %s\n"), line);
		else
		{
			line += strlen(gkey_rc[i].name);
			line += strspn(line , "\t ");
			*(line + strcspn(line,"\n\r")) = '\0';
			switch(gkey_rc[i].id)
			{
#ifdef _GTK_FEATURES_1_2
				case GKEY_MENUACCEL:
				{
					gaccel *ga;

					if ((ga = gaccel_parse_str((guchar *)line)))
					{
						gaccel_add(ga);
					}
					else
						xprintf(0, gettext("Unable to parse: %s\n"), line); 
				}
				break;
#endif
				case GKEY_PROP:
				{
					gprop *gp;

					if ((gp = gprop_parse(line)))
					{
						gprop_add(gp);
					}
					else
						xprintf(0, gettext("Unable to parse: %s\n"), line); 
				}
				break;
				default:
				break;
			}
		}
	}
	fclose(f);
}

void gkey_save()
{
	char pom[2048];
	FILE *f;

	sprintf(pom , "%s/.pavuk_keys" , cfg.path_to_home);

	f = fopen(pom , "w+b");

	if (!f)
	{
		xprintf(0, gettext("Unable to create ~/.pavuk_keys file\n"));
		return;
	}

	fprintf(f, gettext("# This file was generated by %s\n# You may edit it if you're careful!\n\n"), PACKAGE);

#ifdef _GTK_FEATURES_1_2
	gaccel_save_keys(f);
#endif
	gprop_save(f);

	fclose(f);
}
#endif

