/***************************************************************************
                          kartei_sachkonto.cpp  -  description
                             -------------------
    begin                : Mon Jul 24 2000
    version              : $Id: kartei_sachkonto.cpp,v 1.6 2001/03/14 13:59:04 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>

#include "kartei_sachkonto.h"
#include "qdbtableviewsum.h"

Kartei_Sachkonto::Kartei_Sachkonto(QWidget *parent, const char *name,
															SQLQuerier *sql_ptr )
	: QWidget(parent,name)
{
	QBoxLayout *topLayout = new QVBoxLayout( this, 5 );

	dialog = new QDBMenuDialog( this, 0, sql_ptr, false,
									"select * from sachkonto order by nummer", "nummer", "sachkonto",
									"Sachkonto.kdevdlg" );

	sql = sql_ptr;
	table = dialog->dialog->table;

	buchhaltung = new QPopupMenu( this );
	buchhaltung->insertItem( "Buchungen", this, SLOT(sBuchungen()) );
	dialog->menuBar->insertItem( "&Buchhaltung", buchhaltung );

	topLayout->addWidget( dialog, 5 );

	setMinimumSize( dialog->dialog->Page1->sizeHint() );
	setMinimumSize( width()+50, dialog->dialog->Page1->height()+100 );
}

Kartei_Sachkonto::~Kartei_Sachkonto(){
}

void Kartei_Sachkonto::sBuchungen()
{
	QString selectStr = "select * from sachposten where kontonr=";
	selectStr += table->getValue( table->pos, table->fNumber( "nummer" ) );
	selectStr += " order by datum,lfd_nr";

	SQLTable *table2 = new SQLTable( selectStr.ascii(), "lfd_nr" );

	// Test: If you want to see the query before.
	//QMessageBox::information( this, "Test: Posten", selectStr.ascii() );

	table2->execute();

	QDialog *Posten = new QDialog( this, 0, true );
	QDBTableViewSum *view = new QDBTableViewSum( Posten, 0, sql, table2,
			"nettobetrag,mwst_betrag" );
	QBoxLayout *topLayout = new QVBoxLayout( Posten, 5 );
//	QFrame *frSums = new QFrame( Posten );
//	frSums->setFrameStyle( QFrame::Box | QFrame::Sunken );
//	frSums->setFixedHeight(30);

	topLayout->addWidget( view, 5 );
//	topLayout->addWidget( frSums, 5 );

	QString sName = "QtTudo Sachposten Konto-Nr. ";
	sName += table->getValue( table->pos, table->fNumber( "nummer" ) );
	Posten->setCaption( sName );
	Posten->exec();
}
