/***************************************************************************
                          qdbmenudialog.cpp  -  description
                             -------------------
    begin                : Sun Jul 9 2000
    version              : $Id: qdbmenudialog.cpp,v 1.7 2001/03/26 06:45:17 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>

#include "qdbmenudialog.h"

QDBMenuDialog::QDBMenuDialog(QWidget *parent, const char *name,
											SQLQuerier *sql_ptr, bool MakeFields,
											const char *SelectPtr, const char *PrimaryKeyPtr,
											const char *tableName, const char *filename )
	: QWidget(parent,name)
{
	QBoxLayout *topLayout = new QVBoxLayout( this, 5 );

	menuBar = new QMenuBar( this );
	data = new QPopupMenu( this );
	data->insertItem( "Daten &neu lesen", this, SLOT(sNewRead()) );
	menuBar->insertItem( "D&aten", data );
	menuBar->insertSeparator();
	topLayout->setMenuBar( menuBar );

	if (sql_ptr->conn == 0)
		QMessageBox::critical( this, "QtTudo", "Keine Datenbankverbindung aktiv!" );
	else {
		dialog = new QDBDialog( this, 0, sql_ptr, MakeFields, SelectPtr,
													PrimaryKeyPtr, tableName, filename );
		topLayout->addWidget( dialog, 5 );
	}
}

QDBMenuDialog::~QDBMenuDialog(){
}

void QDBMenuDialog::sNewRead()
{
	dialog->Page1->fRead();
}
