/***************************************************************************
                    qdbtableselect.cpp  -  description
                    ----------------------------------
    begin                : 24.04.2000
    version              : $Id: qdbtableselect.cpp,v 1.3 2001/01/04 14:59:27 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : <info@bemme.de> www.bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qpopupmenu.h>
#include <qmessagebox.h>

#include "qdbtableselect.h"
#include "qdbeingabemaske.h"

QDBTableSelect::QDBTableSelect(QWidget *parent, const char *name,
			SQLQuerier *sql_ptr, SQLTable *table_ptr, QString *value_ptr,
			const char *tableName )
	: QDialog(parent,name,true) // modal dialog
{
	sql = sql_ptr;
	table = table_ptr;
	value = value_ptr;
	sName = tableName;

	menuBar = new QMenuBar( this );

	setCaption( name );

	QPopupMenu *fenster = new QPopupMenu( this );
	fenster->insertItem( "&Kladdenauswahl bearbeiten", this, SLOT(sNeueKladdeClicked()) );

	menuBar->insertItem( "&Fenster", fenster );
  menuBar->insertSeparator();
	menuBar->insertItem( "&Ok", this, SLOT(accept()) );
	menuBar->insertItem( "&Abbruch", this, SLOT(reject()) );

  // Datenverbindung herstellen
	if ( sql->conn != NULL ) {
	  if ( table->execute() != SUCCESS_RESULTS )
			QMessageBox::warning( this, "QtTudo", table->ErrorText );
	}	

	if (table->table == 0)
		QMessageBox::warning( this, "QtTudo", "Kein Ergebnis von der Datenbank erhalten!" );

  QVBoxLayout *topLayout = new QVBoxLayout( this );
	Page1 =	new QDBTableView( this, 0, sql, table );
	topLayout->addWidget( Page1 );
	topLayout->setMenuBar( menuBar );
}

QDBTableSelect::~QDBTableSelect()
{

}

void QDBTableSelect::sNeueKladdeClicked()
{
	QDialog *neuePos = new QDialog( this, 0, true );
	QDBEingabemaske *d = new QDBEingabemaske( neuePos, 0, sql, table, sName );

	neuePos->setCaption( "QtTudo: Kladdenauswahl bearbeiten" );
	d->setMinimumSize( d->sizeHint() );
	d->setMinimumSize( d->width()+50, d->height()+100 );

	if (neuePos->exec()) {
		QMessageBox::information( this, "TEST", "Das ist ein Test." );
	}
}

void QDBTableSelect::accept()
{
	value->append( Page1->currentItem()->text(0) );
	QDialog::accept();
}

void QDBTableSelect::reject()
{
	QDialog::reject();
}
