/* keyrings.h - Seahorse
 *
 * Copyright (C) 2000 Anthony Mulcahy
 * Copyright (C) 2000, Jos Carlos Garca Sogo <jsogo@arrakis.es>
 * 
 * Some of the code has been 'borrowed' from
 * GPAPA, The GNU Privacy Pipe Access
 * Copyright (C) 2000 G-N-U GmbH.
 * 
 * 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>

typedef enum
{
  SIG_UNKNOWN,
  SIG_INVALID,
  SIG_VALID
}
SigValidity;

typedef struct
{
  gchar KeyTrust, OwnerTrust;
  gint bits, algorithm;
  GList *uids, *subs;
  gchar *KeyID, *LocalID, *UserID;
  GDate *CreationDate, *ExpirationDate;
  gint secret;
  gchar *fpr;
}
Key;

typedef struct
{
  gint algorithm;
  gchar *KeyID, *UserID;
  GDate *CreationDate;
  SigValidity validity;
}
Signature;

typedef struct
{
  gint bits, algorithm;
  gchar *KeyID, *LocalID;
  GDate *CreationDate, *ExpirationDate;
}
SubKey;

typedef struct
{
  gchar KeyTrust;
  gchar *UserID;
  GList *sigs;
}
Uid;

Key *key_new (gchar * localID);

GDate *extract_date (gchar * date);

gchar *extract_fingerprint (gchar *line);

Key *extract_key (gchar * line);

Signature *signature_new (gchar * keyID);

Signature *extract_sig (gchar * line);

Uid *uid_new (gchar * userID);

Uid *extract_uid (gchar * line);

SubKey *subkey_new (gchar * localID);

SubKey *extract_subkey (gchar * line);

GList *refresh_keyring (GList * PubKeyring);

GList *get_public_keyring (void);

GList *get_uid_siglist (Key * key, gint uid);

void set_uid_siglist (Key * key, gint uid, GList * siglist);

void signature_release (Signature * sig, gpointer user_data);

void uid_release (Uid * uid, gpointer user_data);

void subkey_release (SubKey * sub, gpointer user_data);

void key_release (Key * key, gpointer user_data);

void keyring_release (GList * keyring, gpointer user_data);

void get_secret_keyring (GList * PubKeyring);

Key *keyring_get_key_with_keyid (GList * PubKeyring, gchar * keyid);

gint key_compare_keyids (const Key * data, const gchar *keyid);

Key *keyring_get_key_with_userid (GList * keyring, gchar * userid);

gint key_compare_userids (const Key * data, const gchar * userid);

gint keyring_get_key_uid_position_with_userid (Key *key, gchar * userid);

gint uid_compare_userids (const Uid *data, const gchar * userid);

gchar *algorithm_to_string (gint num_alg);

gchar *trust_to_string (gchar trust);

gint trust_to_int (gchar ctrust);
