/**
 * IPC Messaging
 * Library: joedog
 *
 * Copyright (C) 2000 Jeffrey Fulmer <jdfulmer@armstrong.com>
 * This file is part of Siege
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef IPCMSG_H
#define IPCMSG_H

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif /* HAVE_CONFIG_H */

#include <sys/ipc.h>
#include <sys/msg.h>

#include <joedog/joedog.h>

/* frankly these are pretty esoteric functions
   and should be moved to the application or 
   they should be made malleable.  anyway... */
 
/**
 * create a message queue
 */ 
int create_queue( void );

/**
 * remove message queue ID int.
 */
void remove_queue( int );

/**
 * send a message to queue int containing
 * unsigned long int, int and float, hence
 * the above comment.
 */
void send_message( int, unsigned long int, int, float );

/**
 * send a message type 2 to queue ID int.
 */
void send_message2( int );

#endif /* IPCMSG_H      */ 
