/**
 * Cookies Support
 *
 * Copyright (C) 2001 Jeffrey Fulmer <jdfulmer@armstrong.com>
 * This file is part of Siege
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * --
 *
 */ 
#include <cookie.h>
#include <setup.h>

struct cookie *Cookie  = NULL;
char   oreo[MAX_COOKIE_SIZE];

/**
 * insert values into list
 */
int
add_cookie( char *host, char *cookiestr )
{
  struct cookie *tail = NULL;
  char *lval, *rval;
  char *name, *value, *domain;
  int  d = 0;
  
  tail = xmalloc( sizeof( struct cookie ));

  if( !tail ) joe_fatal( "out of memory!" );

  if(!( cookiestr = strdup( cookiestr ))){
    return -1;
  }

  for( lval = strtok( cookiestr, ";"); lval; lval = strtok(NULL, ";")){
    while( isspace( *lval ))
      lval++;
    rval = strchr( lval, '=' ) + 1;
    *( rval - 1 ) = '\0';

    if( !strcasecmp( lval, "domain" )){
      domain = strdup( rval );
      d = 1;
    }
    else if( !strcasecmp( lval, "path" ) || !strcasecmp( lval, "expires" ) ){ 
	continue; /* ignore path and expire information */
    }
    else{
      name = strdup( lval );
      value = strdup( rval );
    }
  }
  tail->name    = strdup( name );
  tail->value   = strdup( value );
  if( !d )
    tail->domain  = strdup( host );
  else
    tail->domain = strdup( domain );
  tail->next    = Cookie;
  Cookie = tail;

  return 0;
}

int
check_cookie( char *host, char *value )
{
  struct cookie *c;
  c = Cookie;
  while( c != NULL ){
    if( !strcasecmp( c->domain, host ))
      return 1;
    c = c->next;
  }
  add_cookie( host, value );
  return 0;
}

/* 
  get_cookie returns a char * with a compete 
  value of the Cookie: string.  It does NOT
  return the actual Cookie struct.      
*/
char *
get_cookie( char *host )
{
  int dlen, hlen;
  struct cookie *c;
  c = Cookie;
 
  memset( oreo, '\0', sizeof( oreo )); 
  hlen = strlen( host );

  while( c != NULL ){
    dlen = c->domain ? strlen( c->domain ) : 0;
    if( !strcasecmp( c->domain, host )){
      if( strlen( oreo ) > 0 )
        strncat( oreo, ";",    sizeof( oreo ));
      strncat( oreo, c->name,  sizeof( oreo )); 
      strncat( oreo, "=",      sizeof( oreo ));
      strncat( oreo, c->value, sizeof( oreo ));
    }
    if(( dlen < hlen ) && ( !strcasecmp( host + ( hlen - dlen ), c->domain ))){
     if( strlen( oreo ) > 0 )
        strncat( oreo, ";",    sizeof( oreo ));
      strncat( oreo, c->name,  sizeof( oreo ));
      strncat( oreo, "=",      sizeof( oreo ));
      strncat( oreo, c->value, sizeof( oreo ));
    }
    c = c->next;
  }

  return oreo;
}

/*
  Helper util, displays the contents of Cookie
*/
void
display_cookies()
{
  struct cookie *c = Cookie;
  while( c != NULL ){
    printf("HOST: %s, name: %s -> %s\n", c->domain, c->name, c->value);
    c = c->next;
  }
}

