##
## Copyright (C) 2001 Thierry MICHEL <thierry@nekhem.com>
##  
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##  
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##  
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##  
##


try:
    __compatibility__ = ('2.0.7','2.0.8','3.0')
    try:
        import PoPy
    except ImportError:
        raise "The PoPy module is not installed"
    if not PoPy.__version__ in __compatibility__:
        raise "The PoPy module is old: Update your version of PoPy"
except AttributeError:
    raise "The PoPy module is old: Update your version of PoPy"
    
import sys
from Shared.DC.ZRDB.TM import TM
import string, sys
from string import strip, split, find,replace
from types import *

DB_Error = PoPy.Error

class DB(TM):
    """DB class from PoPy driver"""

    def __init__(self,po_conx):
        self._conx = PoPy.connect(po_conx)
        self._conxString = po_conx
        self._cursor = self._conx.cursor
        self._numTry = 0
        self._attempts = 10
        self._seconds = 5

    def setAttempts(self,attempts,seconds):
        try:
            self._attempts = int(attempts)
            self._seconds = int(seconds)
        except ValueError,mesg:
            raise mesg
        
    def connect (self,ps_queryString):
        from time import sleep
        while (self._numTry < self._attempts):
            self._numTry = self._numTry + 1
            try:
                self._conx = PoPy.connect(self._conxString)
                self._numTry = 0
                self._cursor = self._conx.cursor
                return self.query(ps_queryString)
            except PoPy.OperationalError, mesg:
                sleep(self._seconds)
        self._numTry = 0
        raise mesg
                
        
       
        
    def query(self,ps_queryString, pl_maxRows=9999999):
        o_desc = None
        o_result = (); o_items = []
        self._register()
        o_cur = self._cursor()
        ps_queryString = replace(ps_queryString,"\n"," ")
        try:
            for q in filter(None, map(strip,split(ps_queryString, '\0'))):
                try:
                    o_ret = o_cur.execute(q)
                except PoPy.Error,mesg:
                    #return self.connect(ps_queryString)
                    raise sys.exc_type, sys.exc_value, sys.exc_traceback
                
                if o_ret is None:
                    if o_desc is not None:
                        if o_cur.description != o_desc:
                            raise 'Query Error', (
                                'Multiple select schema are not allowed'
                                )
                        if type(o_result) is not ListType:
                            o_result=list(o_result)
                 
			try:
			    o_result = o_cur.fetchall()
			except PoPy.DatabaseError:
			    pass
                 
                    else:
			try:
			    o_result = o_cur.fetchall()
			except PoPy.DatabaseError:
			    pass
                        o_desc = o_cur.description
            o_cur.close()
        except DB_Error, s_mesg:
            o_cur.close()
            raise sys.exc_type, sys.exc_value, sys.exc_traceback
        
        if o_desc is None: return (),()

        o_items = map(lambda x:{'name':x[0],'type':x[1],'dsize':x[2],'isize':x[3],'precision':x[4],'scale':x[5],'null':x[6]}, o_desc)
        
        return o_items,o_result
    
    def _finish (self):
        try:
            self._conx.commit()
            pass
        except (DB_Error), s_mesg:
            raise sys.exc_type, sys.exc_value, sys.exc_traceback
        

    def _abort (self):
        try:
            self._conx.rollback()
        except (DB_Error),s_mesg:
            raise sys.exc_type, sys.exc_value, sys.exc_traceback
        
    def _begin (self):
        pass


