/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.compact;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.apache.accumulo.core.client.admin.CompactionConfig;
import org.apache.accumulo.core.client.admin.PluginConfig;
import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.CompactionStrategyConfigUtil;
import org.apache.accumulo.core.clientImpl.UserCompactionUtils;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.util.FastFormat;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.compact.CompactionDriver;
import org.apache.commons.codec.binary.Hex;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactRange
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(CompactRange.class);
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final NamespaceId namespaceId;
    private final byte[] startRow;
    private final byte[] endRow;
    private byte[] config;

    public CompactRange(NamespaceId namespaceId, TableId tableId, CompactionConfig compactionConfig) throws AcceptableThriftTableOperationException {
        Objects.requireNonNull(namespaceId, "Invalid argument: null namespaceId");
        Objects.requireNonNull(tableId, "Invalid argument: null tableId");
        Objects.requireNonNull(compactionConfig, "Invalid argument: null compaction config");
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        if (!(compactionConfig.getIterators().isEmpty() && CompactionStrategyConfigUtil.isDefault((CompactionConfig)compactionConfig) && compactionConfig.getExecutionHints().isEmpty() && UserCompactionUtils.isDefault((PluginConfig)compactionConfig.getConfigurer()) && UserCompactionUtils.isDefault((PluginConfig)compactionConfig.getSelector()))) {
            this.config = UserCompactionUtils.encode((CompactionConfig)compactionConfig);
        } else {
            log.debug("Using default compaction strategy. No user iterators or compaction strategy provided.");
        }
        if (compactionConfig.getStartRow() != null && compactionConfig.getEndRow() != null && compactionConfig.getStartRow().compareTo((BinaryComparable)compactionConfig.getEndRow()) >= 0) {
            throw new AcceptableThriftTableOperationException(tableId.canonical(), null, TableOperation.COMPACT, TableOperationExceptionType.BAD_RANGE, "start row must be less than end row");
        }
        this.startRow = Optional.ofNullable(compactionConfig.getStartRow()).map(TextUtil::getBytes).orElse(null);
        this.endRow = Optional.ofNullable(compactionConfig.getEndRow()).map(TextUtil::getBytes).orElse(null);
    }

    @Override
    public long isReady(long tid, Manager env) throws Exception {
        return Utils.reserveNamespace(env, this.namespaceId, tid, false, true, TableOperation.COMPACT) + Utils.reserveTable(env, this.tableId, tid, false, true, TableOperation.COMPACT);
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        String zTablePath = "/accumulo/" + String.valueOf(env.getInstanceID()) + "/tables/" + String.valueOf(this.tableId) + "/compact-id";
        ZooReaderWriter zoo = env.getContext().getZooReaderWriter();
        try {
            byte[] cid = zoo.mutateExisting(zTablePath, currentValue -> {
                String cvs = new String(currentValue, StandardCharsets.UTF_8);
                String[] tokens = cvs.split(",");
                long flushID = Long.parseLong(tokens[0]) + 1L;
                String txidString = FastFormat.toHexString((long)tid);
                for (int i = 1; i < tokens.length; ++i) {
                    if (tokens[i].startsWith(txidString)) continue;
                    log.debug("txidString : {}", (Object)txidString);
                    log.debug("tokens[{}] : {}", (Object)i, (Object)tokens[i]);
                    throw new AcceptableThriftTableOperationException(this.tableId.canonical(), null, TableOperation.COMPACT, TableOperationExceptionType.OTHER, "Another compaction with iterators and/or a compaction strategy is running");
                }
                StringBuilder encodedIterators = new StringBuilder();
                if (this.config != null) {
                    Hex hex = new Hex();
                    encodedIterators.append(",");
                    encodedIterators.append(txidString);
                    encodedIterators.append("=");
                    encodedIterators.append(new String(hex.encode(this.config), StandardCharsets.UTF_8));
                }
                return (Long.toString(flushID) + String.valueOf(encodedIterators)).getBytes(StandardCharsets.UTF_8);
            });
            return new CompactionDriver(Long.parseLong(new String(cid, StandardCharsets.UTF_8).split(",")[0]), this.namespaceId, this.tableId, this.startRow, this.endRow);
        }
        catch (KeeperException.NoNodeException nne) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonical(), null, TableOperation.COMPACT, TableOperationExceptionType.NOTFOUND, null);
        }
    }

    static void removeIterators(Manager environment, long txid, TableId tableId) throws Exception {
        String zTablePath = "/accumulo/" + String.valueOf(environment.getInstanceID()) + "/tables/" + String.valueOf(tableId) + "/compact-id";
        ZooReaderWriter zoo = environment.getContext().getZooReaderWriter();
        try {
            zoo.mutateExisting(zTablePath, currentValue -> {
                String cvs = new String(currentValue, StandardCharsets.UTF_8);
                String[] tokens = cvs.split(",");
                long flushID = Long.parseLong(tokens[0]);
                String txidString = FastFormat.toHexString((long)txid);
                StringBuilder encodedIterators = new StringBuilder();
                for (int i = 1; i < tokens.length; ++i) {
                    if (tokens[i].startsWith(txidString)) continue;
                    encodedIterators.append(",");
                    encodedIterators.append(tokens[i]);
                }
                return (Long.toString(flushID) + String.valueOf(encodedIterators)).getBytes(StandardCharsets.UTF_8);
            });
        }
        catch (KeeperException.NoNodeException ke) {
            log.debug("Node for {} no longer exists.", (Object)tableId, (Object)ke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo(long tid, Manager env) throws Exception {
        try {
            CompactRange.removeIterators(env, tid, this.tableId);
        }
        finally {
            Utils.unreserveNamespace(env, this.namespaceId, tid, false);
            Utils.unreserveTable(env, this.tableId, tid, false);
        }
    }
}

