/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.OfflineIterator;
import org.apache.accumulo.core.clientImpl.ScannerOptions;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;

public class OfflineScanner
extends ScannerOptions
implements Scanner {
    private int batchSize;
    private Range range;
    private final ClientContext context;
    private final Authorizations authorizations;
    private final Text tableId;

    public OfflineScanner(ClientContext context, TableId tableId, Authorizations authorizations) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        Preconditions.checkArgument((tableId != null ? 1 : 0) != 0, (Object)"tableId is null");
        Preconditions.checkArgument((authorizations != null ? 1 : 0) != 0, (Object)"authorizations is null");
        this.context = context;
        this.tableId = new Text(tableId.canonical());
        this.range = new Range((Key)null, (Key)null);
        this.authorizations = authorizations;
        this.batchSize = 1000;
    }

    @Override
    public void setRange(Range range) {
        this.range = range;
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public void setBatchSize(int size) {
        this.batchSize = size;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void enableIsolation() {
    }

    @Override
    public void disableIsolation() {
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator() {
        return new OfflineIterator(this, this.context, this.authorizations, this.tableId, this.range);
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public long getReadaheadThreshold() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReadaheadThreshold(long batches) {
        throw new UnsupportedOperationException();
    }
}

