/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.concurrent.atomic.AtomicReference;
import javax.jmdns.impl.NetworkTopologyDiscoveryImpl;

public interface NetworkTopologyDiscovery {
    public InetAddress[] getInetAddresses();

    public boolean useInetAddress(NetworkInterface var1, InetAddress var2);

    public void lockInetAddress(InetAddress var1);

    public void unlockInetAddress(InetAddress var1);

    public static final class Factory {
        private static volatile NetworkTopologyDiscovery _instance;
        private static final AtomicReference<ClassDelegate> _databaseClassDelegate;

        private Factory() {
        }

        public static void setClassDelegate(ClassDelegate delegate) {
            _databaseClassDelegate.set(delegate);
        }

        public static ClassDelegate classDelegate() {
            return _databaseClassDelegate.get();
        }

        private static NetworkTopologyDiscovery newNetworkTopologyDiscovery() {
            NetworkTopologyDiscovery instance = null;
            ClassDelegate delegate = _databaseClassDelegate.get();
            if (delegate != null) {
                instance = delegate.newNetworkTopologyDiscovery();
            }
            return instance != null ? instance : new NetworkTopologyDiscoveryImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static NetworkTopologyDiscovery getInstance() {
            if (_instance != null) return _instance;
            Class<Factory> clazz = Factory.class;
            synchronized (Factory.class) {
                if (_instance != null) return _instance;
                _instance = Factory.newNetworkTopologyDiscovery();
                // ** MonitorExit[var0] (shouldn't be in output)
                return _instance;
            }
        }

        static {
            _databaseClassDelegate = new AtomicReference();
        }

        public static interface ClassDelegate {
            public NetworkTopologyDiscovery newNetworkTopologyDiscovery();
        }
    }
}

