/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.io.IOException;
import java.io.InputStream;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.StreamMessage;

public class StreamMessageInputStream
extends InputStream {
    private final StreamMessage message;
    private volatile boolean eof;

    public StreamMessageInputStream(StreamMessage message) {
        this.message = message;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.message.readByte();
        }
        catch (MessageEOFException e) {
            this.eof = true;
            return -1;
        }
        catch (JMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] array) throws IOException {
        try {
            int num = this.message.readBytes(array);
            this.eof = num < 0;
            return num;
        }
        catch (MessageEOFException e) {
            this.eof = true;
            return -1;
        }
        catch (JMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read(byte[] array, int off, int len) throws IOException {
        try {
            int num = this.message.readBytes(array);
            this.eof = num < 0;
            return num;
        }
        catch (MessageEOFException e) {
            this.eof = true;
            return -1;
        }
        catch (JMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.message.reset();
        }
        catch (JMSException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.eof ? 0 : 1;
    }
}

