/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.lang.invoke.LambdaMetafactory;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.component.timer.TimerConsumer;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;

@org.apache.camel.spi.annotations.Component(value="timer")
public class TimerComponent
extends DefaultComponent {
    private final Map<String, TimerHolder> timers = new ConcurrentHashMap<String, TimerHolder>();
    @Metadata
    private boolean includeMetadata;

    @ManagedAttribute(description="Include metadata")
    public boolean isIncludeMetadata() {
        return this.includeMetadata;
    }

    @ManagedAttribute(description="Include metadata")
    public void setIncludeMetadata(boolean includeMetadata) {
        this.includeMetadata = includeMetadata;
    }

    public Timer getTimer(TimerConsumer consumer) {
        Object key = consumer.getEndpoint().getTimerName();
        if (!consumer.getEndpoint().isDaemon()) {
            key = "nonDaemon:" + (String)key;
        }
        return this.timers.compute((String)key, (BiFunction<String, TimerHolder, TimerHolder>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getTimer$0(org.apache.camel.component.timer.TimerConsumer java.lang.String org.apache.camel.component.timer.TimerComponent$TimerHolder ), (Ljava/lang/String;Lorg/apache/camel/component/timer/TimerComponent$TimerHolder;)Lorg/apache/camel/component/timer/TimerComponent$TimerHolder;)((TimerConsumer)consumer)).timer;
    }

    public void removeTimer(TimerConsumer consumer) {
        Object key = consumer.getEndpoint().getTimerName();
        if (!consumer.getEndpoint().isDaemon()) {
            key = "nonDaemon:" + (String)key;
        }
        this.timers.computeIfPresent((String)key, (k, v) -> {
            if (v.refCount.decrementAndGet() == 0) {
                v.timer.cancel();
                return null;
            }
            return v;
        });
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TimerEndpoint answer = new TimerEndpoint(uri, (Component)this, remaining);
        answer.setIncludeMetadata(this.includeMetadata);
        String time = (String)this.getAndRemoveOrResolveReferenceParameter(parameters, "time", String.class);
        String pattern = (String)this.getAndRemoveOrResolveReferenceParameter(parameters, "pattern", String.class);
        if (time != null) {
            SimpleDateFormat sdf = pattern != null ? new SimpleDateFormat(pattern) : (time.contains("T") ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            Date date = sdf.parse(time);
            answer.setTime(date);
            answer.setPattern(pattern);
        }
        this.setProperties((Endpoint)answer, parameters);
        return answer;
    }

    protected void doStop() throws Exception {
        Collection<TimerHolder> collection = this.timers.values();
        for (TimerHolder holder : collection) {
            holder.timer.cancel();
        }
        this.timers.clear();
    }

    private static /* synthetic */ TimerHolder lambda$getTimer$0(TimerConsumer consumer, String k, TimerHolder v) {
        if (v == null) {
            String name = consumer.getEndpoint().getCamelContext().getExecutorServiceManager().resolveThreadName("timer://" + consumer.getEndpoint().getTimerName());
            return new TimerHolder(new Timer(name, consumer.getEndpoint().isDaemon()));
        }
        v.refCount.incrementAndGet();
        return v;
    }

    private static class TimerHolder {
        private final Timer timer;
        private final AtomicInteger refCount;

        private TimerHolder(Timer timer) {
            this.timer = timer;
            this.refCount = new AtomicInteger(1);
        }
    }
}

