/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view;

import java.util.Map;
import java.util.TreeMap;

public enum SessionField {
    ID("id"),
    CONNECTION_ID("connectionID"),
    CONSUMER_COUNT("consumerCount"),
    PRODUCER_COUNT("producerCount"),
    USER("user"),
    VALIDATED_USER("validatedUser"),
    PROTOCOL("protocol"),
    CLIENT_ID("clientID"),
    LOCAL_ADDRESS("localAddress"),
    REMOTE_ADDRESS("remoteAddress"),
    CREATION_TIME("creationTime");

    private static final Map<String, SessionField> lookup;
    private final String name;

    public String getName() {
        return this.name;
    }

    private SessionField(String name) {
        this.name = name;
    }

    public static SessionField valueOfName(String name) {
        return lookup.get(name);
    }

    static {
        lookup = new TreeMap<String, SessionField>(String.CASE_INSENSITIVE_ORDER);
        for (SessionField e : SessionField.values()) {
            lookup.put(e.name, e);
        }
    }
}

