/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.management.impl.view.predicate;

import java.util.Collection;
import java.util.function.Predicate;

public class ActiveMQFilterPredicate<T>
implements Predicate<T> {
    protected String field;
    protected String value;
    protected Operation operation;

    @Override
    public boolean test(T input) {
        return true;
    }

    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        if (operation != null && !operation.isBlank()) {
            this.operation = Operation.valueOf(operation);
        }
    }

    public boolean matches(Object field) {
        if (this.operation != null) {
            return switch (this.operation.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 2 -> this.equals(field, this.value);
                case 3 -> {
                    if (!this.equals(field, this.value)) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> this.contains(field, this.value);
                case 1 -> {
                    if (!this.contains(field, this.value)) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> false;
                case 5 -> false;
            };
        }
        return true;
    }

    public boolean matchAny(Collection objects) {
        for (Object o : objects) {
            if (!this.matches(o)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(long field) {
        if (this.operation != null) {
            long longValue;
            try {
                longValue = Long.parseLong(this.value);
            }
            catch (NumberFormatException ex) {
                return this.operation == Operation.NOT_EQUALS || this.operation == Operation.NOT_CONTAINS;
            }
            return switch (this.operation.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 2 -> {
                    if (field == longValue) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (field != longValue) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> false;
                case 1 -> true;
                case 5 -> {
                    if (field < longValue) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> field > longValue;
            };
        }
        return true;
    }

    public boolean matches(int field) {
        if (this.operation != null) {
            int intValue;
            try {
                intValue = Integer.parseInt(this.value);
            }
            catch (NumberFormatException ex) {
                return this.operation == Operation.NOT_EQUALS || this.operation == Operation.NOT_CONTAINS;
            }
            return switch (this.operation.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 2 -> {
                    if (field == intValue) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (field != intValue) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> false;
                case 1 -> true;
                case 5 -> {
                    if (field < intValue) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> field > intValue;
            };
        }
        return true;
    }

    public boolean matches(float field) {
        if (this.operation != null) {
            float floatValue;
            try {
                floatValue = Float.parseFloat(this.value);
            }
            catch (NumberFormatException ex) {
                return this.operation == Operation.NOT_EQUALS || this.operation == Operation.NOT_CONTAINS;
            }
            return switch (this.operation.ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 2 -> {
                    if (field == floatValue) {
                        yield true;
                    }
                    yield false;
                }
                case 3 -> {
                    if (field != floatValue) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> false;
                case 1 -> true;
                case 5 -> {
                    if (field < floatValue) {
                        yield true;
                    }
                    yield false;
                }
                case 4 -> field > floatValue;
            };
        }
        return true;
    }

    private boolean equals(Object field, Object value) {
        if (field == null) {
            return value == null || value.equals("");
        }
        return field.toString().equals(value);
    }

    private boolean contains(Object field, Object value) {
        if (field == null) {
            return value == null || value.equals("");
        }
        return field.toString().contains(value.toString());
    }

    public static enum Operation {
        CONTAINS,
        NOT_CONTAINS,
        EQUALS,
        NOT_EQUALS,
        GREATER_THAN,
        LESS_THAN;

    }
}

