/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils.uri;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.apache.activemq.artemis.utils.uri.URIFactory;

public abstract class URISchema<T, P> {
    private URIFactory<T, P> parentFactory;

    public abstract String getSchemaName();

    public T newObject(URI uri, P param) throws Exception {
        return this.newObject(uri, null, param);
    }

    public void populateObject(URI uri, T bean) throws Exception {
        this.internalPopulateObject(uri, URISchema.parseQuery(uri.getQuery(), null), bean);
    }

    public URI newURI(T bean) throws Exception {
        return this.internalNewURI(bean);
    }

    void setFactory(URIFactory<T, P> factory) {
        this.parentFactory = factory;
    }

    protected URIFactory<T, P> getFactory() {
        return this.parentFactory;
    }

    protected String getHost(URI uri) {
        URI defaultFactory = this.getDefaultURI();
        if (defaultFactory != null && uri.getHost() == null && defaultFactory.getScheme() != null && defaultFactory.getScheme().equals(uri.getScheme())) {
            uri = defaultFactory;
        }
        return uri.getHost();
    }

    protected URI getDefaultURI() {
        URIFactory<T, P> factory = this.getFactory();
        if (factory == null) {
            return null;
        }
        return factory.getDefaultURI();
    }

    protected int getPort(URI uri) {
        URI defaultFactory = this.getDefaultURI();
        if (defaultFactory != null && uri.getPort() < 0 && defaultFactory.getScheme().equals(uri.getScheme())) {
            uri = defaultFactory;
        }
        return uri.getPort();
    }

    public T newObject(URI uri, Map<String, String> propertyOverrides, P param) throws Exception {
        return this.internalNewObject(uri, URISchema.parseQuery(uri.getQuery(), propertyOverrides), param);
    }

    protected abstract T internalNewObject(URI var1, Map<String, String> var2, P var3) throws Exception;

    protected URI internalNewURI(T bean) throws Exception {
        String query = BeanSupport.getData(null, bean);
        return new URI(this.getSchemaName(), null, "//", query, null);
    }

    protected void internalPopulateObject(URI uri, Map<String, String> query, T bean) throws Exception {
        BeanSupport.setData(uri, bean, query);
    }

    public static Map<String, String> parseQuery(String uri, Map<String, String> propertyOverrides) {
        HashMap<String, String> rc = new HashMap<String, String>();
        if (uri != null && !uri.isEmpty()) {
            String[] parameters;
            for (String parameter : parameters = uri.split("&")) {
                int p = parameter.indexOf("=");
                if (p >= 0) {
                    String name = BeanSupport.decodeURI(parameter.substring(0, p));
                    String value = BeanSupport.decodeURI(parameter.substring(p + 1));
                    rc.put(name, value);
                    continue;
                }
                if (parameter.trim().isEmpty()) continue;
                rc.put(parameter, null);
            }
        }
        if (propertyOverrides != null) {
            for (Map.Entry<String, String> entry : propertyOverrides.entrySet()) {
                rc.put(entry.getKey(), entry.getValue());
            }
        }
        return rc;
    }

    protected String printQuery(Map<String, String> query) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : query.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }
}

