/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Destination;
import org.apache.qpid.jms.JmsConnection;
import org.apache.qpid.jms.jndi.JNDIStorable;

public abstract class JmsDestination
extends JNDIStorable
implements Externalizable,
Destination,
Comparable<JmsDestination> {
    private static final String NAME_PROP = "address";
    private static final String LEGACY_NAME_PROP = "name";
    protected transient String address;
    protected transient boolean topic;
    protected transient boolean temporary;
    protected transient int hashValue;
    protected transient JmsConnection connection;

    protected JmsDestination(String address, boolean topic, boolean temporary) {
        this.address = address;
        this.topic = topic;
        this.temporary = temporary;
    }

    public String toString() {
        return this.address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isTopic() {
        return this.topic;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isQueue() {
        return !this.topic;
    }

    @Override
    protected Map<String, String> buildFromProperties(Map<String, String> props) {
        this.setAddress(this.getProperty(props, NAME_PROP, this.getProperty(props, LEGACY_NAME_PROP, "")));
        HashMap<String, String> unused = new HashMap<String, String>(props);
        unused.remove(NAME_PROP);
        unused.remove(LEGACY_NAME_PROP);
        return Collections.unmodifiableMap(unused);
    }

    @Override
    protected void populateProperties(Map<String, String> props) {
        props.put(NAME_PROP, this.getAddress());
    }

    @Override
    public int compareTo(JmsDestination other) {
        if (other != null) {
            if (this == other) {
                return 0;
            }
            if (this.isTemporary() == other.isTemporary()) {
                return this.getAddress().compareTo(other.getAddress());
            }
            return -1;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmsDestination other = (JmsDestination)o;
        if (this.address == null && other.address != null) {
            return false;
        }
        if (this.address != null && !this.address.equals(other.address)) {
            return false;
        }
        if (this.temporary != other.temporary) {
            return false;
        }
        return this.topic == other.topic;
    }

    public int hashCode() {
        if (this.hashValue == 0) {
            int prime = 31;
            this.hashValue = 1;
            this.hashValue = 31 * this.hashValue + (this.address == null ? 0 : this.address.hashCode());
            this.hashValue = 31 * this.hashValue + (this.temporary ? 1231 : 1237);
            this.hashValue = 31 * this.hashValue + (this.topic ? 1231 : 1237);
        }
        return this.hashValue;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getAddress());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setAddress(in.readUTF());
    }
}

